/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserver.api;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.untzuntz.ustack.data.APIClient;
import com.untzuntz.ustackserverapi.APICalls;
import com.untzuntz.ustackserverapi.APIResponse;
import com.untzuntz.ustackserverapi.CallParameters;
import com.untzuntz.ustackserverapi.MethodDefinition;
import com.untzuntz.ustackserverapi.auth.AuthTypes;
import com.untzuntz.ustackserverapi.exceptions.UnknownObjectException;
import com.untzuntz.ustackserverapi.params.APICallParam;
import com.untzuntz.ustackserverapi.params.ParamNames;
import com.untzuntz.ustackserverapi.version.Versions;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class PermissionsAPI {
    public void setup(String prefix) {
        MethodDefinition def = new MethodDefinition(String.valueOf(prefix) + "/resource/list", PermissionsAPI.class, "listResourceDefinition");
        def.enableGET(true);
        def.setSinceVersion(Versions.Version100);
        def.setDocumentationGroup("Roles & Permissions");
        def.authenticationMethod(AuthTypes.ClientKey);
        def.setOrder(100);
        def.setDescription("Returns a list of all resource definitions");
        APICalls.addRoute(def);
        def = new MethodDefinition(String.valueOf(prefix) + "/api/client/list", PermissionsAPI.class, "getApiClientList");
        def.enableGET(true);
        def.setSinceVersion(Versions.Version100);
        def.setDocumentationGroup("Roles & Permissions");
        def.authenticationMethod(AuthTypes.ClientKey);
        def.setOrder(100);
        def.setDescription("Returns a list of all api clients");
        APICalls.addRoute(def);
        def = new MethodDefinition(String.valueOf(prefix) + "/api/client", PermissionsAPI.class, "getApiClient");
        def.enableGET(true);
        def.setSinceVersion(Versions.Version100);
        def.setDocumentationGroup("Roles & Permissions");
        def.authenticationMethod(AuthTypes.ClientKey);
        def.addParameter(new APICallParam(ParamNames.client_id), true);
        def.setOrder(100);
        def.setDescription("Returns the information about a single API client");
        APICalls.addRoute(def);
    }

    public void listResourceDefinition(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) {
    }

    public void saveResourceDefinition(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) throws Exception {
    }

    public void deleteResourceDefinition(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) {
    }

    public void saveRole(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) {
    }

    public void deleteRole(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) {
    }

    public void savePermission(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) {
    }

    public void deletePermission(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) {
    }

    public void savePlugin(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) {
    }

    public void deletePlugin(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) {
    }

    public void getApiClientList(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) {
    }

    public void getApiClient(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) throws Exception {
        APIClient client = APIClient.getAPIClient((String)callParams.get(ParamNames.client_id));
        if (client == null) {
            throw new UnknownObjectException(String.format("Could not find API client '%s'", callParams.get(ParamNames.client_id)));
        }
        BasicDBObject ret = new BasicDBObject();
        ret.put("clientId", (Object)client.getClientId());
        BasicDBList outKeyList = new BasicDBList();
        BasicDBList keyList = client.getAPIKeys();
        int i = 0;
        while (i < keyList.size()) {
            DBObject k = (DBObject)keyList.get(i);
            BasicDBObject outKey = new BasicDBObject();
            outKey.put("key", (Object)client.getKey((String)k.get("uid")));
            if ("t".equalsIgnoreCase((String)k.get("revoked"))) {
                outKey.put("revoked", (Object)"true");
            }
            outKeyList.add((Object)outKey);
            ++i;
        }
        ret.put("keys", (Object)outKeyList);
        BasicDBList outResList = new BasicDBList();
        BasicDBList resList = client.getResourceLinkList();
        int i2 = 0;
        while (i2 < resList.size()) {
            DBObject r = (DBObject)resList.get(i2);
            BasicDBObject outRes = new BasicDBObject();
            outRes.put("resource", (Object)((String)r.get("name")));
            outRes.put("role", (Object)((String)r.get("role")));
            outResList.add((Object)outRes);
            ++i2;
        }
        ret.put("access", (Object)outResList);
        APIResponse.httpOk(channel, APIResponse.success((DBObject)ret), callParams);
    }
}

