/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserver.api;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.untzuntz.ustack.data.UniqueReference;
import com.untzuntz.ustack.data.UntzDBObject;
import com.untzuntz.ustack.data.UserAccount;
import com.untzuntz.ustack.main.UForgotPasswordSvc;
import com.untzuntz.ustackserverapi.APIDocumentation;
import com.untzuntz.ustackserverapi.APIResponse;
import com.untzuntz.ustackserverapi.CallParameters;
import com.untzuntz.ustackserverapi.MethodDefinition;
import com.untzuntz.ustackserverapi.params.ParamNames;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.stream.ChunkedStream;
import org.jboss.netty.util.CharsetUtil;
import org.w3c.dom.Document;

public class BasicAPI {
    static Logger logger = Logger.getLogger(BasicAPI.class);

    public void documentationCss(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) throws Exception {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        channel.write((Object)response);
        ChannelFuture writeFuture = channel.write((Object)new ChunkedStream(ClassLoader.class.getResourceAsStream("/com/untzuntz/ustackserver/docs/apidocs.css")));
        writeFuture.addListener(ChannelFutureListener.CLOSE);
    }

    public void documentation(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) throws Exception {
        BasicAPI.generateDocumentation(def, channel, req, callParams, null);
    }

    public static void generateDocumentation(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams, HashMap<String, String> documentationDefaults) throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        String docHtmlResourcePath = (String)def.getData("documentationHtmlResourcePath");
        if (docHtmlResourcePath == null) {
            docHtmlResourcePath = "/com/untzuntz/ustackserver/docs/documentation.html";
        }
        InputStream input = null;
        try {
            input = ClassLoader.class.getResourceAsStream(docHtmlResourcePath);
            InputStreamReader xslReader = new InputStreamReader(input);
            String clientId = callParams.get(ParamNames.client_id);
            String apiKey = callParams.get(ParamNames.api_key);
            String baseUrl = (String)def.getData("baseUrl");
            Document doc = APIDocumentation.getDocumentationXML(baseUrl, "curl", clientId, apiKey, 12, documentationDefaults);
            DOMSource xml = new DOMSource(doc);
            StreamSource xsl = new StreamSource(xslReader);
            Transformer transformer = tFactory.newTransformer(xsl);
            transformer.clearParameters();
            StringWriter strWriter = new StringWriter();
            StreamResult result = new StreamResult(strWriter);
            transformer.transform(xml, result);
            DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            res.setHeader("Content-type", (Object)"text/html");
            res.setContent(ChannelBuffers.copiedBuffer((CharSequence)strWriter.toString(), (Charset)CharsetUtil.UTF_8));
            HttpHeaders.setContentLength((HttpMessage)res, (long)res.getContent().readableBytes());
            channel.write((Object)res).addListener(ChannelFutureListener.CLOSE);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void hashtest(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) throws Exception {
        String serverSig = callParams.getRequestSignature(def.getHashKey());
        BasicDBObject resp = new BasicDBObject("serverSignature", (Object)serverSig);
        String clientSig = "(NOT PROVIDED)";
        if (callParams.get(ParamNames.RequestSignature) != null) {
            clientSig = callParams.get(ParamNames.RequestSignature);
        }
        resp.put("clientSignature", (Object)clientSig);
        resp.put("signatureStatus", (Object)"Error");
        if (clientSig.equals(serverSig)) {
            resp.put("signatureStatus", (Object)"Match");
        }
        APIResponse.httpOk(channel, (DBObject)resp, callParams);
    }

    public void confirmEmailAddress(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) throws Exception {
        UniqueReference ref = UniqueReference.getByUID((String)callParams.get(ParamNames.UID));
        if (ref != null) {
            logger.info((Object)("Loaded unique reference from uid : " + callParams.get(ParamNames.UID)));
            ref.put("used", (Object)"true");
            UniqueReference.save((UntzDBObject)ref, (String)ref.getString("userName"));
            UserAccount user = UserAccount.getUser((String)ref.getString("userName"));
            if (user != null) {
                user.put("emailConfirmed", (Object)"true");
                user.save(user.getUserName());
            }
            if (ref.get("successUrl") != null) {
                DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.TEMPORARY_REDIRECT);
                res.setHeader("Location", (Object)((String)ref.get("successUrl")));
                HttpHeaders.setContentLength((HttpMessage)res, (long)res.getContent().readableBytes());
                channel.write((Object)res).addListener(ChannelFutureListener.CLOSE);
            } else {
                APIResponse.httpOk(channel, APIResponse.success(""), callParams);
            }
            return;
        }
        APIResponse.httpError(channel, APIResponse.error("Error during email confirmation process"), callParams);
    }

    public void forgotPassword(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) throws Exception {
        UserAccount usrAcct = UserAccount.getUser((String)callParams.get(ParamNames.username));
        if (usrAcct != null && !usrAcct.isDisabled()) {
            try {
                UForgotPasswordSvc.sendForgotPassword((String)usrAcct.getUserName(), (DBObject)BasicAPI.getClientIPObject(channel, req), (String)((String)def.getData("url")), (String)usrAcct.getUserName(), (String)usrAcct.getPrimaryEmail(), (String)usrAcct.getFullName(), (String)((String)def.getData("template")));
            }
            catch (Exception e) {
                logger.warn((Object)("User [" + usrAcct.getUserName() + "] hit an exception during forgot password"), (Throwable)e);
                APIResponse.httpError(channel, APIResponse.error("Error during forgot password request"), callParams);
                return;
            }
            APIResponse.httpOk(channel, APIResponse.success(""), callParams);
        } else {
            APIResponse.httpError(channel, APIResponse.error("Error during forgot password request"), callParams);
        }
    }

    public void resetPassword(MethodDefinition def, Channel channel, HttpRequest req, CallParameters callParams) throws Exception {
        UserAccount usrAcct = UserAccount.getUser((String)callParams.get(ParamNames.username));
        if (usrAcct != null && !usrAcct.isDisabled()) {
            try {
                UForgotPasswordSvc.sendResetPassword((String)usrAcct.getUserName(), (DBObject)BasicAPI.getClientIPObject(channel, req), (String)usrAcct.getUserName(), (String)usrAcct.getPrimaryEmail(), (String)usrAcct.getFullName(), (String)((String)def.getData("template")), null);
            }
            catch (Exception e) {
                logger.warn((Object)("User [" + usrAcct.getUserName() + "] hit an exception during forgot password"), (Throwable)e);
                APIResponse.httpError(channel, APIResponse.error("Error during reset password request"), callParams);
                return;
            }
            APIResponse.httpOk(channel, APIResponse.success(""), callParams);
        } else {
            APIResponse.httpError(channel, APIResponse.error("Error during reset password request"), callParams);
        }
    }

    public static DBObject getClientIPObject(Channel channel, HttpRequest req) {
        String clientCountry;
        String clientIP = req.getHeader("X-Real-IP");
        if (clientIP == null) {
            clientIP = req.getHeader("X-Forwarded-For");
        }
        if (clientIP == null) {
            clientIP = channel.getRemoteAddress().toString();
        }
        if ((clientCountry = req.getHeader("X-Country-Code")) == null) {
            clientCountry = "UNK";
        }
        logger.info((Object)("IP: " + clientIP + " -> " + clientCountry));
        BasicDBObject ret = new BasicDBObject();
        ret.put("requestIP", (Object)clientIP);
        ret.put("requestCountry", (Object)clientCountry);
        return ret;
    }
}

