/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserver.api;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.untzuntz.ustack.data.APILog;
import com.untzuntz.ustackserverapi.CallParameters;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class APITracker {
    public static APILog create(CallParameters params, Channel chl, HttpRequest req, HttpResponse res, String responseBody) {
        APILog ret = new APILog();
        ret.put("method", (Object)req.getMethod());
        ret.put("uri", (Object)params.getPath());
        String realSourceIP = req.getHeader("X-Real-IP");
        if (realSourceIP == null) {
            realSourceIP = chl.getRemoteAddress().toString();
        }
        String countryCode = req.getHeader("X-Country-Code");
        ret.put("sourceIP", (Object)realSourceIP);
        ret.put("sourceCountry", (Object)countryCode);
        List reqHeaders = req.getHeaders();
        BasicDBList headerList = new BasicDBList();
        for (Map.Entry entry : reqHeaders) {
            headerList.add((Object)new BasicDBObject((String)entry.getKey(), entry.getValue()));
        }
        ret.put("requestHeaders", (Object)headerList);
        ret.put("requestParams", (Object)params.getParameterList());
        ret.put("responseCode", (Object)res.getStatus().getCode());
        Iterator headers = res.getHeaderNames().iterator();
        headerList = new BasicDBList();
        while (headers.hasNext()) {
            String hdr = (String)headers.next();
            headerList.add((Object)new BasicDBObject(hdr, (Object)res.getHeader(hdr)));
        }
        ret.put("responseHeaders", (Object)headerList);
        ret.put("responseBody", (Object)responseBody);
        ret.save("API Tracker");
        return ret;
    }
}

