/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserver;

import com.untzuntz.ustackserver.server.ServerFactory;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class Main {
    static Logger logger = Logger.getLogger(Main.class);
    private int port;
    private String apiVersion;

    public static void main(String[] args) throws Exception {
        DOMConfigurator.configure((String)"log4j.xml");
        int port = 8081;
        if (args.length >= 1) {
            port = Integer.valueOf(args[1]);
        }
        Main main = new Main(args[0], port);
        main.run();
    }

    public String getAPIVersion() {
        return this.apiVersion;
    }

    public Main(String code, int p) {
        this.port = p;
        try {
            Class<?> apiClass = Class.forName(code);
            Object apiObj = apiClass.newInstance();
            Method m = apiClass.getMethod("setup", new Class[0]);
            m.invoke(apiObj, null);
            m = apiClass.getMethod("getAPIVersion", new Class[0]);
            Object o = m.invoke(apiObj, new Object[0]);
            this.apiVersion = (String)o;
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to load API subset", (Throwable)e);
        }
    }

    public void run() {
        logger.info((Object)("Staring client server on port " + this.port));
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        bootstrap.setOption("backlog", (Object)1000);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new ServerFactory());
        bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
    }
}

