/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserver;

import com.untzuntz.ustack.data.ExternalAPIParams;
import com.untzuntz.ustack.main.ConfigEnc;
import com.untzuntz.ustack.main.UOpts;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;

public class ConfigEncHelper {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("ConfigEncHelper [file to encrypt] <outputfile>");
            return;
        }
        String name = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        if (args.length != 2) {
            System.out.print("Data Name (unique): ");
            name = br.readLine();
            System.out.print("Database (ex: test@localhost): ");
            String db = br.readLine();
            if (db.indexOf("@") == -1) {
                System.err.println("Invalid database name");
                System.exit(1);
            }
            String dbName = db.substring(0, db.indexOf("@"));
            String dbLoc = db.substring(db.indexOf("@") + 1);
            UOpts.setAppName((String)dbName);
            System.setProperty("MongoDB.DefaultHost", dbLoc);
        }
        System.out.print("Passphrase: ");
        String passphrase = null;
        try {
            passphrase = br.readLine();
        }
        catch (IOException ioe) {
            System.err.println("IO error trying to the passphrase");
            System.exit(1);
        }
        if (passphrase.length() < 10) {
            System.err.println("Passphrase must be at least 10 characters");
            System.exit(1);
        }
        ConfigEnc ce = new ConfigEnc(passphrase);
        File inFile = new File(args[0]);
        FileInputStream in = new FileInputStream(inFile);
        int readLen = 0;
        int toRead = (int)inFile.length();
        byte[] buf = new byte[8192];
        StringBuffer srcData = new StringBuffer();
        while ((readLen = in.read(buf, 0, toRead)) != -1) {
            srcData.append(new String(Arrays.copyOfRange(buf, 0, readLen)));
            if ((toRead -= readLen) == 0) break;
        }
        in.close();
        String readBack = null;
        if (name != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ce.encrypt(srcData.toString(), (OutputStream)out);
            ExternalAPIParams params = ExternalAPIParams.createExternalAPIParams((String)name, (ByteArrayOutputStream)out);
            params.save("ceh");
            params = ExternalAPIParams.getByName((String)name);
            readBack = ce.decrypt(params.getKeyDataStream());
        } else {
            File encFile = new File(args[1]);
            FileOutputStream out = new FileOutputStream(encFile);
            ce.encrypt(srcData.toString(), (OutputStream)out);
            out.close();
            FileInputStream rbin = new FileInputStream(encFile);
            readBack = ce.decrypt((InputStream)rbin);
        }
        if (!srcData.toString().equals(readBack)) {
            System.out.println("  source data [" + srcData + "] => " + srcData.length());
            System.out.println("readback data [" + readBack + "] => " + readBack.length());
            System.err.println("There was an error during the encryption/decryption test. Data did not match!");
        } else {
            System.out.println("Data successfully read back");
        }
    }
}

