/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.remote;

import com.univocity.api.Range;
import com.univocity.api.UI;
import com.univocity.api.common.Args;
import com.univocity.api.common.ParameterizedString;
import com.univocity.api.io.FileProvider;
import com.univocity.api.statistics.DownloadListener;
import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.Context;
import com.univocity.parsers.common.EntityParserSettings;
import com.univocity.parsers.common.Nesting;
import com.univocity.parsers.remote.CommonFollowerOptions;
import com.univocity.parsers.remote.Paginator;
import com.univocity.parsers.remote.RemoteEntityList;
import java.io.File;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class RemoteParserSettings<S extends CommonParserSettings, L extends RemoteEntityList, C extends Context>
extends EntityParserSettings<S, L, C>
implements CommonFollowerOptions {
    private static ExecutorService DEFAULT_THREAD_POOL;
    private String emptyValue;
    protected Paginator paginator;
    private Charset textEncoding = Charset.defaultCharset();
    private FileProvider downloadContentDirectory;
    protected Boolean downloadBeforeParsingEnabled = null;
    private ParameterizedString fileNamePattern;
    private boolean downloadOverwritingEnabled = true;
    private Boolean downloadEnabled;
    private Nesting nesting = Nesting.LINK;
    private boolean ignoreLinkFollowingErrors = false;
    private DownloadListener downloadListener;
    private int downloadThreads = 4;
    private ExecutorService executorService;
    private long remoteInterval = 15L;
    private Date parseDate;
    private String batchId;

    public final void setDownloadContentDirectory(String path) {
        this.downloadContentDirectory = new FileProvider(path);
    }

    @UI(order=1)
    public final void setDownloadContentDirectory(File directory) {
        this.downloadContentDirectory = new FileProvider(directory);
    }

    public final FileProvider getDownloadContentDirectory() {
        return this.downloadContentDirectory;
    }

    @UI(order=2)
    public final void setFileNamePattern(String pattern) {
        this.fileNamePattern = new ParameterizedString(pattern);
        this.parseDate = null;
    }

    public final String getFileNamePattern() {
        return this.getParameterizedFileName().applyParameterValues();
    }

    public final Charset getTextEncoding() {
        return this.textEncoding;
    }

    public final void setTextEncoding(Charset encoding) {
        this.textEncoding = encoding == null ? Charset.defaultCharset() : encoding;
    }

    public final void setTextEncoding(String charsetName) {
        this.setTextEncoding(Charset.forName(charsetName));
    }

    final ParameterizedString getParameterizedFileName() {
        if (this.fileNamePattern == null) {
            this.fileNamePattern = new ParameterizedString("file_{page}");
        }
        return this.fileNamePattern;
    }

    public final void setFileNameParameter(String parameterName, Object parameterValue) {
        this.getParameterizedFileName().set(parameterName, parameterValue);
    }

    public final Object getFileNameParameter(String parameterName) {
        return this.getParameterizedFileName().get(parameterName);
    }

    public final Set<String> getFileNameParameters() {
        return this.getParameterizedFileName().getParameters();
    }

    public final void clearFileNameParameters() {
        this.getParameterizedFileName().clearValues();
    }

    public void setPaginator(Paginator paginator) {
        this.paginator = paginator;
    }

    public Paginator getPaginator() {
        if (this.paginator == null) {
            this.paginator = this.newPaginator(this);
        }
        return this.paginator;
    }

    protected abstract Paginator newPaginator(RemoteParserSettings var1);

    public final String getEmptyValue() {
        return this.emptyValue;
    }

    @UI
    public final void setEmptyValue(String emptyValue) {
        this.emptyValue = emptyValue;
    }

    public final boolean isColumnReorderingEnabled() {
        return this.globalSettings.isColumnReorderingEnabled();
    }

    public final void setColumnReorderingEnabled(boolean columnReorderingEnabled) {
        this.globalSettings.setColumnReorderingEnabled(columnReorderingEnabled);
    }

    public DownloadListener getDownloadListener() {
        return this.downloadListener;
    }

    public void setDownloadListener(DownloadListener downloadListener) {
        this.downloadListener = downloadListener;
    }

    public abstract String getDefaultFileExtension();

    public boolean isDownloadOverwritingEnabled() {
        return this.downloadOverwritingEnabled;
    }

    @UI
    public void setDownloadOverwritingEnabled(boolean downloadOverwritingEnabled) {
        this.downloadOverwritingEnabled = downloadOverwritingEnabled;
    }

    public boolean isDownloadBeforeParsingEnabled() {
        return this.downloadBeforeParsingEnabled != null && this.downloadBeforeParsingEnabled != false || this.downloadContentDirectory != null;
    }

    @UI
    public void setDownloadBeforeParsingEnabled(boolean downloadBeforeParsingEnabled) {
        this.downloadBeforeParsingEnabled = downloadBeforeParsingEnabled;
    }

    @Range(min=1, max=16)
    @UI(order=3)
    public final void setDownloadThreads(int downloadThreads) {
        Args.positive((Number)downloadThreads, (String)"Number of threads for content download");
        this.downloadThreads = downloadThreads;
    }

    public final int getDownloadThreads() {
        return this.downloadThreads <= 0 ? 4 : this.downloadThreads;
    }

    @Override
    public final Nesting getNesting() {
        return this.nesting;
    }

    @Override
    public final void setNesting(Nesting nesting) {
        if (nesting == null) {
            nesting = Nesting.LINK;
        }
        this.nesting = nesting;
    }

    public final void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ExecutorService getExecutorService() {
        if (this.executorService != null && !this.executorService.isShutdown()) return this.executorService;
        if (DEFAULT_THREAD_POOL != null && !DEFAULT_THREAD_POOL.isShutdown()) return DEFAULT_THREAD_POOL;
        Class<RemoteParserSettings> clazz = RemoteParserSettings.class;
        synchronized (RemoteParserSettings.class) {
            DEFAULT_THREAD_POOL = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DEFAULT_THREAD_POOL;
        }
    }

    @Override
    public void ignoreFollowingErrors(boolean ignoreLinkFollowingErrors) {
        this.ignoreLinkFollowingErrors = ignoreLinkFollowingErrors;
    }

    @Override
    public boolean isIgnoreFollowingErrors() {
        return this.ignoreLinkFollowingErrors;
    }

    @Override
    protected RemoteParserSettings<S, L, C> clone() {
        RemoteParserSettings out = (RemoteParserSettings)super.clone();
        out.paginator = null;
        out.fileNamePattern = null;
        return out;
    }

    public final long getRemoteInterval() {
        return this.remoteInterval;
    }

    public final void setRemoteInterval(long remoteInterval) {
        this.remoteInterval = remoteInterval;
    }

    public final void setParseDate(Calendar parseDate) {
        if (parseDate == null) {
            this.setParseDate((Date)null);
        } else {
            this.setParseDate(parseDate.getTime());
        }
    }

    public final void setParseDate(Date parseDate) {
        this.parseDate = parseDate;
        if (parseDate != null && this.downloadEnabled == null) {
            this.downloadEnabled = false;
        }
    }

    public final void setParseDate(String parseDate) {
        if (parseDate == null) {
            this.setParseDate((Date)null);
        } else {
            ParameterizedString pattern = this.getParameterizedFileName();
            if (pattern.contains("date")) {
                String format = pattern.getFormat("date");
                if (format == null) {
                    try {
                        long millis = Long.valueOf(parseDate);
                        this.setParseDate(new Date(millis));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Can't convert parse Date '" + parseDate + "' to a long. Try setting a date mask in your parameterizedFileName {date} parameter. Current pattern: " + pattern, e);
                    }
                }
                try {
                    this.setParseDate(new SimpleDateFormat(format).parse(parseDate));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Can't parse date '" + parseDate + "' using mask " + format + ". Current pattern: " + pattern, e);
                }
            }
            throw new IllegalArgumentException("Can't set formatted parse Date '" + parseDate + "' if the parameterizedFileName has no {date} parameter. Current parameterizedFileName: " + pattern);
        }
    }

    public final String getParseDate() {
        Date date = this.parseDate == null ? new Date() : this.parseDate;
        ParameterizedString pattern = this.getParameterizedFileName();
        if (pattern.contains("date")) {
            String format = pattern.getFormat("date");
            if (format == null) {
                return String.valueOf(date.getTime());
            }
            return new SimpleDateFormat(format).format(date);
        }
        return String.valueOf(date.getTime());
    }

    public final String getBatchId() {
        return this.batchId;
    }

    public final void setBatchId(String batchId) {
        this.batchId = batchId;
        if (batchId != null && this.downloadEnabled == null) {
            this.downloadEnabled = false;
        }
    }

    public final void setDownloadEnabled(boolean downloadEnabled) {
        this.downloadEnabled = downloadEnabled;
    }

    public final boolean isDownloadEnabled() {
        return this.downloadEnabled == null ? true : this.downloadEnabled;
    }
}

