/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.remote;

import com.univocity.api.common.Args;
import com.univocity.api.common.ParameterizedString;
import com.univocity.api.common.ValueGetter;
import com.univocity.api.net.UrlReaderProvider;
import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.EntityList;
import com.univocity.parsers.common.EntitySettings;
import com.univocity.parsers.common.Nesting;
import com.univocity.parsers.remote.CommonFollowerOptions;
import com.univocity.parsers.remote.NextInputHandler;
import com.univocity.parsers.remote.RemoteContext;
import com.univocity.parsers.remote.RemoteEntityList;
import com.univocity.parsers.remote.RemoteEntitySettings;
import com.univocity.parsers.remote.RemoteParserSettings;
import java.util.TreeMap;

public abstract class RemoteFollower<S extends RemoteEntitySettings, T extends RemoteEntityList<S>, R extends RemoteParserSettings>
implements Cloneable,
CommonFollowerOptions {
    protected T entityList;
    protected R parserSettings;
    protected S entitySettings;
    protected final RemoteFollower parentLinkFollower;
    private UrlReaderProvider baseUrl;
    private Nesting nesting = null;
    private Boolean ignoreLinkFollowingErrors = null;
    protected NextInputHandler<RemoteContext> nextLinkHandler;
    boolean stopped;
    boolean parentHasDate;
    protected TreeMap<String, ValueGetter<?>> urlParameters;

    protected RemoteFollower(S parentEntitySettings) {
        ArgumentUtils.notEmpty((String)"Parent of remote follower", (Object[])new RemoteEntitySettings[]{parentEntitySettings});
        this.entityList = ((RemoteEntitySettings)parentEntitySettings).getParentEntityList().newInstance();
        this.entitySettings = ((RemoteEntityList)this.entityList).addEntitySettings(parentEntitySettings);
        this.parserSettings = ((RemoteEntityList)this.entityList).getParserSettings();
        this.parentLinkFollower = (RemoteFollower)((RemoteEntitySettings)this.entitySettings).owner;
        ((RemoteEntitySettings)this.entitySettings).owner = this;
        this.urlParameters = new TreeMap();
        ParameterizedString paramString = ((RemoteParserSettings)this.parserSettings).getParameterizedFileName();
        ((RemoteParserSettings)this.parserSettings).setFileNamePattern("{parent}/file_{entry}");
    }

    public final T getEntityList() {
        return this.entityList;
    }

    public final S addEntity(String entityName) {
        S out = ((RemoteEntityList)this.entityList).configureEntity(entityName, this.entitySettings);
        ((RemoteEntitySettings)out).owner = this;
        return out;
    }

    public final S getEntity(String entityName) {
        return (S)((RemoteEntitySettings)((EntityList)this.entityList).getEntity(entityName));
    }

    public final R getParserSettings() {
        return this.parserSettings;
    }

    public final UrlReaderProvider getBaseUrl() {
        return this.baseUrl;
    }

    public final void setBaseUrl(UrlReaderProvider baseUrlReaderProvider) {
        this.baseUrl = baseUrlReaderProvider;
    }

    public RemoteFollower assigning(String parameterName, Object parameterValue) {
        Args.notNull((Object)parameterValue, (String)parameterName);
        this.baseUrl.getRequest().setUrlParameter(parameterName, parameterValue);
        return this;
    }

    public RemoteFollower assigning(String parameterName, ValueGetter<?> valueGetter) {
        this.urlParameters.put(parameterName, valueGetter);
        return this;
    }

    @Override
    public final void ignoreFollowingErrors(boolean ignoreLinkFollowingErrors) {
        this.ignoreLinkFollowingErrors = ignoreLinkFollowingErrors;
    }

    @Override
    public final boolean isIgnoreFollowingErrors() {
        if (this.ignoreLinkFollowingErrors == null) {
            if (this.parentLinkFollower != null) {
                return this.parentLinkFollower.isIgnoreFollowingErrors();
            }
            return ((RemoteEntitySettings)this.entitySettings).isIgnoreFollowingErrors();
        }
        return this.ignoreLinkFollowingErrors;
    }

    @Override
    public final Nesting getNesting() {
        if (this.nesting == null) {
            if (this.parentLinkFollower != null) {
                return this.parentLinkFollower.getNesting();
            }
            return ((RemoteEntitySettings)this.entitySettings).getNesting();
        }
        return this.nesting;
    }

    @Override
    public final void setNesting(Nesting nesting) {
        this.nesting = nesting;
    }

    public String toString() {
        return ">>" + ((EntitySettings)this.entitySettings).getEntityName();
    }

    public NextInputHandler<RemoteContext> getNextLinkHandler() {
        return this.nextLinkHandler;
    }

    public void setNextLinkHandler(NextInputHandler<RemoteContext> nextLinkHandler) {
        this.nextLinkHandler = nextLinkHandler;
    }
}

