/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.remote;

import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.Context;
import com.univocity.parsers.common.EntitySettings;
import com.univocity.parsers.common.Nesting;
import com.univocity.parsers.remote.CommonFollowerOptions;
import com.univocity.parsers.remote.RemoteEntityList;
import com.univocity.parsers.remote.RemoteFollower;
import com.univocity.parsers.remote.RemoteParserSettings;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class RemoteEntitySettings<C extends Context, S extends CommonParserSettings, G extends RemoteParserSettings, T extends RemoteFollower>
extends EntitySettings<C, S, G>
implements CommonFollowerOptions {
    private boolean localEmptyValue;
    private String emptyValue = null;
    private boolean localColumnReorderingEnabled;
    protected Set<String> requestParameters = new LinkedHashSet<String>();
    protected Map<String, T> followers = new HashMap<String, T>();
    private Boolean ignoreLinkFollowingErrors;
    private Nesting nesting;
    protected Object owner;

    protected RemoteEntitySettings(String entityName, S entitySettings, RemoteEntitySettings parentEntity) {
        super(entityName, entitySettings, parentEntity);
    }

    @Override
    public final Nesting getNesting() {
        if (this.nesting == null) {
            if (this.parentEntity != null) {
                return ((RemoteEntitySettings)this.parentEntity).getNesting();
            }
            return ((RemoteParserSettings)this.parserSettings).getNesting();
        }
        return this.nesting;
    }

    @Override
    public final void setNesting(Nesting combineLinkFollowingRows) {
        this.nesting = combineLinkFollowingRows;
    }

    @Override
    public final void ignoreFollowingErrors(boolean ignoreLinkFollowingErrors) {
        this.ignoreLinkFollowingErrors = ignoreLinkFollowingErrors;
    }

    @Override
    public final boolean isIgnoreFollowingErrors() {
        if (this.ignoreLinkFollowingErrors == null) {
            if (this.parentEntity != null) {
                return ((RemoteEntitySettings)this.parentEntity).isIgnoreFollowingErrors();
            }
            return ((RemoteParserSettings)this.parserSettings).isIgnoreFollowingErrors();
        }
        return this.ignoreLinkFollowingErrors;
    }

    @Override
    protected S getInternalSettings() {
        return (S)((CommonParserSettings)super.getInternalSettings());
    }

    public abstract Set<String> getFieldNames();

    public abstract void removeField(String var1);

    public final boolean isColumnReorderingEnabled() {
        if (this.localColumnReorderingEnabled || this.parserSettings == null) {
            return this.getInternalSettings().isColumnReorderingEnabled();
        }
        return ((RemoteParserSettings)this.parserSettings).isColumnReorderingEnabled();
    }

    public final void setColumnReorderingEnabled(boolean columnReorderingEnabled) {
        this.localColumnReorderingEnabled = true;
        this.getInternalSettings().setColumnReorderingEnabled(columnReorderingEnabled);
    }

    public final String getEmptyValue() {
        if (this.localEmptyValue || this.parserSettings == null) {
            return this.emptyValue;
        }
        return ((RemoteParserSettings)this.parserSettings).getEmptyValue();
    }

    public final void setEmptyValue(String emptyValue) {
        this.localEmptyValue = true;
        this.emptyValue = emptyValue;
    }

    public Map<String, T> getRemoteFollowers() {
        return Collections.unmodifiableMap(this.followers);
    }

    @Override
    protected RemoteEntityList getParentEntityList() {
        return (RemoteEntityList)super.getParentEntityList();
    }

    public T getRemoteFollower(String followerName) {
        return (T)((RemoteFollower)this.followers.get(followerName));
    }

    @Override
    protected EntitySettings<C, S, G> clone() {
        RemoteEntitySettings out = (RemoteEntitySettings)super.clone();
        out.followers = new HashMap<String, T>();
        this.requestParameters = new LinkedHashSet<String>();
        return out;
    }
}

