/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.CommonSettings;
import com.univocity.parsers.common.Context;
import com.univocity.parsers.common.EntityList;
import com.univocity.parsers.common.EntityParserSettings;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.ProcessorErrorHandler;
import com.univocity.parsers.common.fields.FieldSet;
import com.univocity.parsers.common.processor.core.NoopProcessor;
import com.univocity.parsers.common.processor.core.Processor;
import java.util.TreeMap;

public abstract class EntitySettings<C extends Context, S extends CommonSettings, G extends EntityParserSettings>
implements Cloneable {
    private EntityList<EntitySettings<C, S, G>> parentEntityList;
    private S internalSettings;
    protected G parserSettings;
    private boolean localNullValue;
    private boolean localProcessorErrorHandler;
    private boolean localErrorContentLength;
    private boolean localTrimLeading;
    private boolean localTrimTrailing;
    protected final String name;
    protected Processor<C> processor;
    protected final EntitySettings parentEntity;

    protected EntitySettings(String name, S internalSettings, EntitySettings parentEntity) {
        this.name = name;
        this.internalSettings = internalSettings;
        this.parentEntity = parentEntity;
    }

    protected final void setParent(EntityList parentEntityList) {
        this.parentEntityList = parentEntityList;
        this.parserSettings = parentEntityList.getParserSettings();
    }

    protected static final CommonParserSettings createEmptyParserSettings() {
        return new CommonParserSettings(){

            protected Format createDefaultFormat() {
                return new Format(){

                    protected TreeMap<String, Object> getConfiguration() {
                        return new TreeMap<String, Object>();
                    }
                };
            }
        };
    }

    public final String getNullValue() {
        if (this.localNullValue || this.parserSettings == null && this.parentEntity == null) {
            return this.internalSettings.getNullValue();
        }
        if (this.parentEntity != null) {
            return this.parentEntity.getNullValue();
        }
        return ((EntityParserSettings)this.parserSettings).globalSettings.getNullValue();
    }

    public final void setNullValue(String nullValue) {
        this.localNullValue = true;
        this.internalSettings.setNullValue(nullValue);
    }

    public final FieldSet<String> selectFields(String ... fieldNames) {
        return this.internalSettings.selectFields(fieldNames);
    }

    public final FieldSet<String> excludeFields(String ... fieldNames) {
        return this.internalSettings.excludeFields(fieldNames);
    }

    public final FieldSet<Integer> selectIndexes(Integer ... fieldIndexes) {
        return this.internalSettings.selectIndexes(fieldIndexes);
    }

    public final FieldSet<Integer> excludeIndexes(Integer ... fieldIndexes) {
        return this.internalSettings.excludeIndexes(fieldIndexes);
    }

    public final FieldSet<Enum> selectFields(Enum ... columns) {
        return this.internalSettings.selectFields(columns);
    }

    public final FieldSet<Enum> excludeFields(Enum ... columns) {
        return this.internalSettings.excludeFields(columns);
    }

    public final boolean isAutoConfigurationEnabled() {
        return this.internalSettings.isAutoConfigurationEnabled();
    }

    public final void setAutoConfigurationEnabled(boolean autoConfigurationEnabled) {
        this.internalSettings.setAutoConfigurationEnabled(autoConfigurationEnabled);
    }

    public final <T extends Context> ProcessorErrorHandler<T> getProcessorErrorHandler() {
        if (this.localProcessorErrorHandler || this.parserSettings == null && this.parentEntity == null) {
            return this.internalSettings.getProcessorErrorHandler();
        }
        if (this.parentEntity != null) {
            return this.parentEntity.getProcessorErrorHandler();
        }
        return ((EntityParserSettings)this.parserSettings).globalSettings.getProcessorErrorHandler();
    }

    public final void setProcessorErrorHandler(ProcessorErrorHandler<? extends Context> processorErrorHandler) {
        this.localProcessorErrorHandler = true;
        this.internalSettings.setProcessorErrorHandler(processorErrorHandler);
    }

    public final boolean isProcessorErrorHandlerDefined() {
        if (this.localProcessorErrorHandler || this.parserSettings == null && this.parentEntity == null) {
            return this.internalSettings.isProcessorErrorHandlerDefined();
        }
        if (this.parentEntity != null) {
            return this.parentEntity.isProcessorErrorHandlerDefined();
        }
        return ((EntityParserSettings)this.parserSettings).globalSettings.isProcessorErrorHandlerDefined();
    }

    final void autoConfigure() {
        if (!this.internalSettings.isAutoConfigurationEnabled()) {
            return;
        }
        this.runAutomaticConfiguration();
    }

    public final int getErrorContentLength() {
        if (this.localErrorContentLength || this.parserSettings == null && this.parentEntity == null) {
            return this.internalSettings.getErrorContentLength();
        }
        if (this.parentEntity != null) {
            return this.parentEntity.getErrorContentLength();
        }
        return ((EntityParserSettings)this.parserSettings).globalSettings.getErrorContentLength();
    }

    public final void setErrorContentLength(int errorContentLength) {
        this.localErrorContentLength = true;
        this.internalSettings.setErrorContentLength(errorContentLength);
    }

    protected final void runAutomaticConfiguration() {
        this.internalSettings.runAutomaticConfiguration();
    }

    protected S getInternalSettings() {
        return this.internalSettings;
    }

    public final String getEntityName() {
        return this.name;
    }

    public final String toString() {
        return this.name;
    }

    public final Processor<C> getProcessor() {
        return this.processor == null ? NoopProcessor.instance : this.processor;
    }

    public final void setProcessor(Processor<C> processor) {
        this.processor = processor;
    }

    public final boolean getTrimTrailingWhitespaces() {
        if (this.localTrimTrailing || this.parserSettings == null && this.parentEntity == null) {
            return this.internalSettings.getIgnoreTrailingWhitespaces();
        }
        if (this.parentEntity != null) {
            return this.parentEntity.getTrimTrailingWhitespaces();
        }
        return ((EntityParserSettings)this.parserSettings).globalSettings.getIgnoreTrailingWhitespaces();
    }

    public final void setTrimTrailingWhitespaces(boolean trimTrailingWhitespaces) {
        this.localTrimTrailing = true;
        this.internalSettings.setIgnoreTrailingWhitespaces(trimTrailingWhitespaces);
    }

    public final boolean getTrimLeadingWhitespaces() {
        if (this.localTrimLeading || this.parserSettings == null && this.parentEntity == null) {
            return this.internalSettings.getIgnoreLeadingWhitespaces();
        }
        if (this.parentEntity != null) {
            return this.parentEntity.getTrimLeadingWhitespaces();
        }
        return ((EntityParserSettings)this.parserSettings).globalSettings.getIgnoreLeadingWhitespaces();
    }

    public final void setTrimLeadingWhitespaces(boolean trimLeadingWhitespaces) {
        this.localTrimLeading = true;
        this.internalSettings.setIgnoreLeadingWhitespaces(trimLeadingWhitespaces);
    }

    public final void trimValues(boolean trim) {
        this.localTrimTrailing = true;
        this.localTrimLeading = true;
        this.internalSettings.trimValues(trim);
    }

    protected EntityList getParentEntityList() {
        return this.parentEntityList;
    }

    protected EntitySettings<C, S, G> clone() {
        try {
            EntitySettings out = (EntitySettings)super.clone();
            out.internalSettings = this.internalSettings.clone(true);
            if (this.parserSettings != null) {
                out.parserSettings = ((EntityParserSettings)this.parserSettings).clone();
            }
            out.processor = null;
            return out;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Unable to clone", e);
        }
    }
}

