/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api.statistics;

import com.univocity.api.net.UrlReaderProvider;
import com.univocity.api.statistics.DataTransferListener;
import com.univocity.api.statistics.DownloadStatistics;
import java.io.File;

public abstract class DownloadListener
extends DataTransferListener<UrlReaderProvider, File, DownloadStatistics> {
    private String unitDescription;
    private long unitDivisor;
    private final long notificationInterval;

    public DownloadListener() {
        this(250L);
    }

    public DownloadListener(long notificationInterval) {
        this.notificationInterval = notificationInterval;
    }

    @Override
    protected final DownloadStatistics newDataTransfer(UrlReaderProvider source, long totalSize, File target) {
        DownloadStatistics out = new DownloadStatistics(this.notificationInterval){

            @Override
            protected void dataDownloaded(DownloadStatistics status, boolean lastNotification) {
                DownloadListener.this.dataDownloaded(status, lastNotification);
            }
        };
        if (this.unitDescription != null) {
            out.setUnit(this.unitDescription, this.unitDivisor);
        }
        return out;
    }

    protected abstract void dataDownloaded(DownloadStatistics var1, boolean var2);

    public void setUnit(String unitDescription, long unitDivisor) {
        this.unitDescription = unitDescription;
        this.unitDivisor = unitDivisor;
        for (DownloadStatistics stats : this) {
            stats.setUnit(unitDescription, unitDivisor);
        }
    }
}

