/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api.statistics;

import com.univocity.api.common.NotificationHandler;
import com.univocity.api.common.TimedNotificationHandler;
import com.univocity.api.statistics.DataTransfer;
import java.sql.Date;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.concurrent.TimeUnit;

public class DataTransferStatistics<S, T>
implements DataTransfer<S, T> {
    private S source;
    private T target;
    private double totalSize = -1.0;
    private double totalTransferredSoFar = -1.0;
    private double totalTransferredRecently = 0.0;
    private double ratePerSecond;
    private long startTime = -1L;
    private long endTime = -1L;
    private boolean aborted;
    private Exception abortError;
    private SimpleDateFormat dateFormat;
    private String dateMask;
    private String description;
    private String unitDescription;
    private double unitDivisor = 1.0;
    private NotificationHandler<DataTransferStatistics<S, T>> notificationHandler;
    long lastSecond = 0L;

    public DataTransferStatistics() {
        this(0L, null);
    }

    public DataTransferStatistics(NotificationHandler<DataTransferStatistics<S, T>> notificationHandler) {
        this(0L, notificationHandler);
    }

    public DataTransferStatistics(long notificationInterval, NotificationHandler<DataTransferStatistics<S, T>> handler) {
        this.setNotificationHandler(notificationInterval, handler);
    }

    protected final void setNotificationHandler(NotificationHandler<DataTransferStatistics<S, T>> handler) {
        this.setNotificationHandler(0L, handler);
    }

    protected final void setNotificationHandler(long notificationInterval, final NotificationHandler<DataTransferStatistics<S, T>> handler) {
        this.notificationHandler = notificationInterval > 0L ? new TimedNotificationHandler<DataTransferStatistics<S, T>>(notificationInterval){

            @Override
            protected void onNotification(DataTransferStatistics<S, T> n, boolean lastNotification) {
                handler.notify(n, lastNotification);
            }
        } : handler;
    }

    public final String getUnitDescription() {
        return this.unitDescription == null ? "" : this.unitDescription;
    }

    public final void setUnit(String unitDescription) {
        this.unitDescription = unitDescription;
    }

    public void setUnit(String unitDescription, long unitDivisor) {
        this.unitDescription = unitDescription;
        if (unitDivisor == 0L) {
            unitDivisor = 1L;
        }
        this.unitDivisor = unitDivisor;
    }

    public final long getUnitDivisor() {
        return (long)this.unitDivisor;
    }

    @Override
    public final void started(S source, long totalSize, T target) {
        if (this.isRunning()) {
            throw new IllegalStateException("Data transfer statistics already started: " + this.toString());
        }
        this.source = source;
        this.target = target;
        this.description = source + " -> " + target;
        this.totalSize = totalSize;
        this.startTime = System.currentTimeMillis();
        this.totalTransferredSoFar = 0.0;
        this.totalTransferredRecently = 0.0;
        this.endTime = -1L;
    }

    @Override
    public final void transferred(S source, long transferred, T target) {
        if (transferred > 0L && this.source == source && this.target == target) {
            this.totalTransferredSoFar += (double)transferred;
            this.totalTransferredRecently += (double)transferred;
            this.notifyStatisticUpdates();
        }
    }

    private void updateRatePerSecond() {
        if (this.lastSecond <= 0L) {
            this.lastSecond = System.currentTimeMillis();
            this.totalTransferredRecently = 0.0;
            return;
        }
        long time = System.currentTimeMillis() - this.lastSecond;
        if (time < 1000L) {
            return;
        }
        this.ratePerSecond = this.totalTransferredRecently / this.unitDivisor / (double)time * 1000.0;
        this.totalTransferredRecently = 0.0;
        this.lastSecond = System.currentTimeMillis();
    }

    private void notifyStatisticUpdates() {
        if (this.notificationHandler != null) {
            this.updateRatePerSecond();
            this.notificationHandler.notify(this, this.endTime > 0L);
        }
    }

    @Override
    public final void completed(S source, T target) {
        if (this.source == source && this.target == target) {
            this.endTime = System.currentTimeMillis();
            this.notifyStatisticUpdates();
        }
    }

    @Override
    public final void aborted(S source, T target, Exception error) {
        if (this.source == source && this.target == target) {
            this.aborted = true;
            this.abortError = error;
            this.completed(source, target);
        }
    }

    public final double getAverageRate() {
        return this.getAverageRate(TimeUnit.MILLISECONDS);
    }

    public final double getAverageRate(TimeUnit timeUnit) {
        long time = this.getTimeElapsed();
        if ((time = timeUnit.convert(time, TimeUnit.MILLISECONDS)) > 0L) {
            return this.getTotalTransferredSoFar() / (double)time;
        }
        return this.getTotalTransferredSoFar();
    }

    public final long getTimeElapsed() {
        if (this.endTime > 0L) {
            return this.endTime - this.startTime;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public final double getTimeElapsed(TimeUnit timeUnit) {
        return timeUnit.convert(this.getTimeElapsed(), TimeUnit.MILLISECONDS);
    }

    public final double getTotalTransferredSoFar() {
        return this.totalTransferredSoFar / this.unitDivisor;
    }

    public final double getTotalSize() {
        if (!this.aborted && this.endTime > 0L) {
            return this.totalTransferredSoFar / this.unitDivisor;
        }
        return this.totalSize / this.unitDivisor;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    private String getTime(long time, String dateMask, String valueOnError) {
        if (this.dateMask != null && !this.dateMask.equals(dateMask)) {
            this.dateFormat = null;
        }
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat(dateMask);
            this.dateMask = dateMask;
        }
        try {
            return this.dateFormat.format(new Date(time));
        }
        catch (Exception ex) {
            return valueOnError;
        }
    }

    public final String getStartTime(String dateMask, String valueOnError) {
        return this.getTime(this.startTime, dateMask, valueOnError);
    }

    public final String getStartTime(String dateMask) {
        return this.getTime(this.startTime, dateMask, "N/A");
    }

    public final long getEndTime() {
        return this.endTime;
    }

    public final String getEndTime(String dateMask, String valueOnError) {
        return this.getTime(this.endTime, dateMask, valueOnError);
    }

    public final String getEndTime(String dateMask) {
        return this.getTime(this.endTime, dateMask, "N/A");
    }

    public final double getTransferPercentage() {
        if (this.totalSize > 0.0) {
            return this.getTotalTransferredSoFar() / this.getTotalSize();
        }
        if (this.aborted) {
            return 0.0;
        }
        if (this.endTime > 0L) {
            return 1.0;
        }
        return 0.0;
    }

    public final S getSource() {
        return this.source;
    }

    public final T getTarget() {
        return this.target;
    }

    public final Exception getAbortError() {
        return this.abortError;
    }

    @Override
    public final boolean isStarted() {
        return this.totalTransferredSoFar != -1.0;
    }

    @Override
    public final boolean isRunning() {
        return this.isStarted() && this.endTime <= 0L;
    }

    @Override
    public final boolean isAborted() {
        return this.aborted;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTransferStatistics that = (DataTransferStatistics)o;
        if (!this.source.equals(that.source)) {
            return false;
        }
        return this.target.equals(that.target);
    }

    public final int hashCode() {
        int result = this.source.hashCode();
        result = 31 * result + this.target.hashCode();
        return result;
    }

    public String toString() {
        if (this.totalTransferredSoFar == -1.0) {
            return "Not started";
        }
        StringBuilder stats = new StringBuilder(" | ");
        stats.append(this.getFormattedTotalTransferredSoFar());
        stats.append(" of ").append(this.getFormattedTotalSize());
        stats.append(' ').append('(');
        stats.append(this.getFormattedTransferPercentage());
        if (this.aborted) {
            if (this.abortError != null) {
                return this.description + stats.toString() + ") | Aborted with error " + this.abortError.getMessage();
            }
            return this.description + stats.toString() + ") | Aborted";
        }
        stats.append(' ').append('-').append(' ');
        stats.append(this.getFormattedRatePerSecond());
        stats.append(" (avg ").append(this.getFormattedAverageRate()).append(')');
        if (this.endTime < 0L) {
            return this.description + stats.toString() + " | Transferring ";
        }
        return this.description + stats.toString() + " | Completed ";
    }

    public String getFormattedTransferPercentage(NumberFormat format, String valueIfUnknown) {
        if (this.getTotalSize() > 0.0) {
            return format.format(this.getTransferPercentage());
        }
        return valueIfUnknown;
    }

    public String getFormattedTransferPercentage() {
        return this.getFormattedTransferPercentage(NumberFormat.getPercentInstance(), "?%");
    }

    public final double getRatePerSecond() {
        this.updateRatePerSecond();
        if (this.ratePerSecond == 0.0) {
            return this.getAverageRate();
        }
        return this.ratePerSecond;
    }

    public String getFormattedRatePerSecond(NumberFormat format, String rateSymbol) {
        return this.getFormattedRate(this.getRatePerSecond(), format, rateSymbol);
    }

    public String getFormattedRatePerSecond() {
        return this.getFormattedRatePerSecond(NumberFormat.getNumberInstance(), " /sec");
    }

    private String getFormattedRate(double rate, NumberFormat format, String rateSymbol) {
        StringBuilder out = new StringBuilder();
        out.append(format.format(rate));
        if (!this.getUnitDescription().isEmpty()) {
            out.append(this.getUnitDescription());
        }
        if (rateSymbol != null && !rateSymbol.isEmpty()) {
            out.append(rateSymbol);
        }
        return out.toString();
    }

    public String getFormattedAverageRate(NumberFormat format, TimeUnit timeUnit, String rateSymbol) {
        return this.getFormattedRate(this.getAverageRate(timeUnit), format, rateSymbol);
    }

    public String getFormattedAverageRate() {
        return this.getFormattedAverageRate(NumberFormat.getNumberInstance(), TimeUnit.SECONDS, " /sec");
    }

    public String getFormattedTotalTransferredSoFar(NumberFormat format) {
        StringBuilder out = new StringBuilder();
        out.append(format.format(this.getTotalTransferredSoFar()));
        if (!this.getUnitDescription().isEmpty()) {
            out.append(' ');
            out.append(this.getUnitDescription());
        }
        return out.toString();
    }

    public String getFormattedTotalTransferredSoFar() {
        return this.getFormattedTotalTransferredSoFar(NumberFormat.getNumberInstance());
    }

    public String getFormattedTotalSize(NumberFormat format, String valueIfUnknown) {
        StringBuilder out = new StringBuilder();
        if (this.getTotalSize() > 0.0) {
            out.append(format.format(this.getTotalSize()));
        } else {
            out.append(valueIfUnknown);
        }
        if (!this.getUnitDescription().isEmpty()) {
            out.append(' ');
            out.append(this.getUnitDescription());
        }
        return out.toString();
    }

    public String getFormattedTotalSize() {
        return this.getFormattedTotalSize(NumberFormat.getNumberInstance(), "?");
    }
}

