/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api.statistics;

import com.univocity.api.statistics.DataTransfer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class DataTransferListener<S, T, E extends DataTransfer<S, T>>
implements DataTransfer<S, T>,
Iterable<E> {
    private Map<T, E> active = new ConcurrentHashMap<T, E>();
    private LinkedHashSet<E> order = new LinkedHashSet();

    @Override
    public synchronized void started(S source, long totalSize, T target) {
        DataTransfer previousTransfer = (DataTransfer)this.active.get(target);
        if (previousTransfer != null && previousTransfer.isRunning()) {
            previousTransfer.aborted(source, target, null);
            this.order.remove(previousTransfer);
        }
        E transfer = this.newDataTransfer(source, totalSize, target);
        transfer.started(source, totalSize, target);
        this.order.add(transfer);
        this.active.put(target, transfer);
    }

    @Override
    public void transferred(S source, long transferred, T target) {
        DataTransfer transfer = (DataTransfer)this.active.get(target);
        if (transfer != null) {
            transfer.transferred(source, transferred, target);
        }
    }

    @Override
    public synchronized void completed(S source, T target) {
        DataTransfer transfer = (DataTransfer)this.active.remove(target);
        if (transfer != null) {
            this.order.remove(transfer);
            transfer.completed(source, target);
        }
    }

    @Override
    public synchronized void aborted(S source, T target, Exception error) {
        DataTransfer transfer = (DataTransfer)this.active.remove(target);
        if (transfer != null) {
            this.order.remove(transfer);
            transfer.aborted(source, target, error);
        }
    }

    protected abstract E newDataTransfer(S var1, long var2, T var4);

    @Override
    public final boolean isStarted() {
        return true;
    }

    @Override
    public final boolean isRunning() {
        return !this.active.isEmpty();
    }

    @Override
    public final boolean isAborted() {
        return false;
    }

    public int size() {
        return this.active.size();
    }

    public List<E> getActiveTransfers() {
        return new ArrayList<E>(this.order);
    }

    @Override
    public Iterator<E> iterator() {
        return this.order.iterator();
    }
}

