/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api.net;

import com.univocity.api.Builder;
import com.univocity.api.Range;
import com.univocity.api.UI;
import com.univocity.api.io.FileProvider;
import com.univocity.api.io.RateLimiter;
import com.univocity.api.io.ReaderProvider;
import com.univocity.api.net.HttpRequest;
import com.univocity.api.net.HttpResponse;
import java.io.File;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;

public class UrlReaderProvider
extends ReaderProvider
implements Cloneable {
    private int retries = 0;
    private long retryInterval = 2000L;
    private HttpResponse response;
    private HttpRequest request;
    private FileProvider localCopyProvider;
    private URL url;

    public UrlReaderProvider(String url) {
        this.request = new HttpRequest(url, null);
    }

    public UrlReaderProvider(String url, RateLimiter rateLimiter) {
        this.request = new HttpRequest(url, rateLimiter);
    }

    public final String getUrl() {
        if (this.response != null && this.request.getFollowRedirects() && this.response.getRedirectionUrl() != null) {
            return this.response.getRedirectionUrl();
        }
        return this.request.getUrl();
    }

    public final URL getUrlInstance() {
        if (this.url == null || !this.url.toString().equals(this.getUrl())) {
            try {
                this.url = new URL(this.getUrl());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Invalid URL " + this.getUrl(), ex);
            }
        }
        return this.url;
    }

    public final boolean isResponseAvailable() {
        return this.response != null;
    }

    public final String getDomainName() {
        return this.getUrlInstance().getAuthority();
    }

    public final HttpRequest getRequest() {
        return this.request;
    }

    public final String getProtocol() {
        return this.getUrlInstance().getProtocol();
    }

    public final int getRetries() {
        return this.retries;
    }

    @Range(min=0, max=10)
    @UI
    public final void setRetries(int retries) {
        this.retries = retries;
    }

    public final long getRetryInterval() {
        return this.retryInterval;
    }

    @Range(min=0, max=10000)
    @UI
    public final void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public final String getPath() {
        return this.getUrlInstance().getPath();
    }

    public final String getFileName() {
        int fragment;
        String path = this.getPath();
        if (path == null) {
            return null;
        }
        int lastSlash = path.lastIndexOf(47);
        int query = Math.max(path.indexOf(63), 0);
        int end = Math.min(query, fragment = Math.max(path.indexOf(35), 0));
        if (end == 0) {
            return path.substring(lastSlash + 1);
        }
        if (end < path.length() && end > lastSlash + 1) {
            return path.substring(lastSlash + 1, end);
        }
        return null;
    }

    public final HttpResponse getResponse() {
        if (this.response == null) {
            this.response = Builder.build(HttpResponse.class, this);
        }
        return this.response;
    }

    public final void storeLocalCopyIn(FileProvider provider) {
        this.localCopyProvider = provider;
    }

    public final void storeLocalCopyIn(File file) {
        this.localCopyProvider = new FileProvider(file);
    }

    public final void storeLocalCopyIn(File file, Charset encoding) {
        this.localCopyProvider = new FileProvider(file, encoding);
    }

    public final void storeLocalCopyIn(File file, String encoding) {
        this.localCopyProvider = new FileProvider(file, encoding);
    }

    public final void storeLocalCopyIn(String path) {
        this.localCopyProvider = new FileProvider(path);
    }

    public final void storeLocalCopyIn(String path, Charset encoding) {
        this.localCopyProvider = new FileProvider(path, encoding);
    }

    public final void storeLocalCopyIn(String path, String encoding) {
        this.localCopyProvider = new FileProvider(path, encoding);
    }

    public final FileProvider getLocalCopyTarget() {
        return this.localCopyProvider;
    }

    @Override
    public final Reader getResource() {
        try {
            return this.getResponse().getContentReader();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to open URL '" + this.request.getUrl() + "'", ex);
        }
    }

    public final String toString() {
        return this.request.getUrl();
    }

    public final UrlReaderProvider clone() {
        try {
            UrlReaderProvider clone = (UrlReaderProvider)super.clone();
            clone.response = null;
            clone.request = this.request.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Unable to clone", e);
        }
    }

    public final UrlReaderProvider newRequest(String newUrl) {
        UrlReaderProvider out = this.clone();
        out.getRequest().setUrl(newUrl);
        return out;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlReaderProvider that = (UrlReaderProvider)o;
        return this.request != null ? this.request.equals(that.request) : that.request == null;
    }

    public int hashCode() {
        return this.request != null ? this.request.hashCode() : 0;
    }
}

