/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api.net;

import com.univocity.api.Choices;
import com.univocity.api.Range;
import com.univocity.api.UI;
import com.univocity.api.common.Args;
import com.univocity.api.common.ParameterizedString;
import com.univocity.api.common.Utils;
import com.univocity.api.io.RateLimiter;
import com.univocity.api.io.ResourceProvider;
import com.univocity.api.net.DataParameter;
import com.univocity.api.net.HttpMessage;
import com.univocity.api.net.RequestMethod;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;

public class HttpRequest
extends HttpMessage
implements Cloneable {
    private ParameterizedString url;
    private int timeout;
    private boolean followRedirects = true;
    private List<DataParameter> data = new ArrayList<DataParameter>();
    private Charset charset;
    private boolean ignoreHttpErrors;
    private String proxyUser;
    private char[] proxyPassword;
    private RateLimiter rateLimiter;
    private SSLSocketFactory sslSocketFactory;
    private int bodySizeLimit;
    private String requestBody;
    private Charset postDataCharset = Charset.forName("UTF-8");
    private Proxy proxy;

    protected HttpRequest(String url, RateLimiter rateLimiter) {
        this.setUrl(url);
        this.rateLimiter = rateLimiter;
        this.addHeader("Accept-Encoding", "gzip");
        this.setUserAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36");
    }

    public final RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public final void setRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public final void setUrl(String url) {
        Args.notBlank(url, "HTTP request URL");
        Map<Object, Object> oldParameters = Collections.emptyMap();
        if (this.url != null) {
            oldParameters = this.url.getParameterValues();
        }
        this.url = new ParameterizedString(url);
        for (String param : this.url.getParameters()) {
            this.url.set(param, oldParameters.get(param));
        }
    }

    public final int getBodySizeLimit() {
        return this.bodySizeLimit;
    }

    public final void setBodySizeLimit(int limit) {
        Args.positiveOrZero(limit, "body size limit");
        this.bodySizeLimit = limit;
    }

    public final String getRequestBody() {
        return this.requestBody;
    }

    public final void setRequestBody(String body) {
        this.requestBody = body;
    }

    public final Charset getPostDataCharset() {
        return this.postDataCharset;
    }

    public final String getPostDataCharsetName() {
        return this.postDataCharset.name();
    }

    public final void setPostDataCharset(String charsetName) {
        Args.notBlank(charsetName, "Charset name for POST data request");
        this.setPostDataCharset(Charset.forName(charsetName));
    }

    public final void setPostDataCharset(Charset postDataCharset) {
        Args.notNull(postDataCharset, "Charset for POST data request");
        this.postDataCharset = postDataCharset;
    }

    public final void setKeepAliveEnabled(boolean enableKeepAlive) {
        this.setHeader("Connection", enableKeepAlive ? "keep-alive" : "close");
    }

    @Choices(file="userAgents.txt")
    @UI
    public final void setUserAgent(String userAgent) {
        this.setHeader("User-Agent", userAgent);
    }

    @UI
    public final void setReferrer(String referrer) {
        this.setHeader("Referer", referrer);
    }

    public final void addHeader(String header, String value) {
        this.addHeader(header, value, false);
    }

    public final void addHeader(String header, String value, boolean encode) {
        if (encode) {
            value = Args.encode(value);
        }
        this.addMulti(this.headers, header, value);
    }

    public final void setHeader(String header, String value) {
        this.setHeader(header, value, false);
    }

    public final void setHeader(String header, String value, boolean encode) {
        if (encode) {
            value = Args.encode(value);
        }
        this.setMulti(this.headers, header, value);
    }

    public final void setHeaders(Map<String, String> headers) {
        this.setHeaders(headers, false);
    }

    public final void addHeaders(Map<String, String> headers) {
        this.addHeaders(headers, false);
    }

    public final void setHeaders(Map<String, String> headers, boolean encode) {
        this.headers.clear();
        this.addHeaders(headers, encode);
    }

    public final void addHeaders(Map<String, String> headers, boolean encode) {
        if (encode) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                this.addMulti(this.headers, e.getKey(), Args.encode(e.getValue()));
            }
        } else {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                this.addMulti(this.headers, e.getKey(), e.getValue());
            }
        }
    }

    public final void setCookie(String cookie, String value) {
        this.set(this.cookies, cookie, value);
    }

    public final void setCookies(Map<String, String> cookies) {
        this.cookies.clear();
        this.addCookies(cookies);
    }

    public final void addCookies(Map<String, String> cookies) {
        for (Map.Entry<String, String> e : cookies.entrySet()) {
            this.set(this.cookies, e.getKey(), e.getValue());
        }
    }

    public final void removeCookie(String name) {
        this.cookies.remove(name);
    }

    private void addMulti(Map<String, List<String>> map, String key, String value) {
        Utils.putValueCaseInsensitive(map, key, value, true);
    }

    private void setMulti(Map<String, List<String>> map, String key, String value) {
        Utils.putValueCaseInsensitive(map, key, value, false);
    }

    private void set(Map<String, String> map, String key, String value) {
        if (value == null) {
            map.remove(key);
        } else {
            map.put(key, value);
        }
    }

    @Range(min=0, max=10000)
    @UI
    public final void setTimeout(int timeout) {
        Args.positiveOrZero(timeout, "HTTP request timeout");
        this.timeout = timeout;
    }

    public final void setRequestMethod(RequestMethod httpMethodType) {
        Args.notNull((Object)httpMethodType, "HTTP method type");
        this.requestMethod = httpMethodType;
    }

    public final String getUrl() {
        return this.url.applyParameterValues();
    }

    public final void setUrlParameter(String parameterName, Object parameterValue) {
        this.setUrlParameter(parameterName, parameterValue, true);
    }

    public final Object getUrlParameter(String parameterName) {
        return this.url.get(parameterName);
    }

    public final Set<String> getUrlParameters() {
        return this.url.getParameters();
    }

    public final void setUrlParameter(String parameterName, Object parameterValue, boolean encode) {
        if (encode) {
            parameterValue = Args.encode(parameterName, parameterValue, this.getCharsetName("UTF-8"));
        }
        this.url.set(parameterName, parameterValue);
    }

    public final String getCharsetName(String defaultIfNull) {
        String name = this.getCharsetName();
        if (name == null) {
            return defaultIfNull;
        }
        return name;
    }

    public final String getUrlParameter(String parameterName, boolean decode) {
        Object out = this.url.get(parameterName);
        if (decode) {
            return Args.decode(parameterName, out, this.getCharsetName("UTF-8"));
        }
        if (out != null) {
            return String.valueOf(out);
        }
        return null;
    }

    public final void clearUrlParameters() {
        this.url.clearValues();
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final boolean getFollowRedirects() {
        return this.followRedirects;
    }

    @UI
    public final void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public final void addDataParameter(DataParameter dataParameter) {
        Args.notNull(dataParameter, "Data parameter");
        this.data.add(dataParameter);
    }

    public final void removeDataParameter(String paramName) {
        Args.notBlank(paramName, "Parameter name");
        Iterator<DataParameter> it = this.data.iterator();
        while (it.hasNext()) {
            DataParameter entry = it.next();
            if (!paramName.equals(entry.getName())) continue;
            it.remove();
        }
    }

    public final List<DataParameter> getDataParameter(String paramName) {
        Args.notBlank(paramName, "Parameter name");
        ArrayList<DataParameter> out = new ArrayList<DataParameter>(1);
        for (DataParameter entry : this.data) {
            if (!paramName.equals(entry.getName())) continue;
            out.add(entry);
        }
        return out;
    }

    public final void setDataParameter(DataParameter dataParameter) {
        Args.notNull(dataParameter, "data parameter");
        this.removeDataParameter(dataParameter.getName());
        this.addDataParameter(dataParameter);
    }

    public final void setDataParameters(Map<String, String[]> params, String ... keys) {
        this.clearDataParameters();
        this.addDataParameters(params, keys);
    }

    public final void addDataParameters(Map<String, String[]> params, String ... keys) {
        if (keys.length == 0) {
            for (Map.Entry<String, String[]> e : params.entrySet()) {
                this.addDataParameters(e.getKey(), e.getValue());
            }
        } else {
            for (String key : keys) {
                this.addDataParameters(key, params.get(key));
            }
        }
    }

    private void addDataParameters(String key, String[] values) {
        if (key == null) {
            return;
        }
        if (values == null || values.length == 0) {
            this.addDataParameter(key, "");
        } else {
            for (int i = 0; i < values.length; ++i) {
                this.addDataParameter(key, values[i]);
            }
        }
    }

    public final void addDataParameter(String paramName, Object value) {
        this.data.add(new DataParameter(paramName, value == null ? "" : String.valueOf(value)));
    }

    public final void setDataParameter(String paramName, Object value) {
        this.removeDataParameter(paramName);
        this.data.add(new DataParameter(paramName, value == null ? "" : String.valueOf(value)));
    }

    public final List<DataParameter> getData() {
        return this.data;
    }

    public final void removeHeader(String name) {
        Map.Entry entry = Utils.getEntryCaseInsensitive(this.headers, name);
        if (entry != null) {
            this.headers.remove(entry.getKey());
        }
    }

    public void addDataParameter(String key, String filename, InputStream inputStream, String contentType) {
        this.data.add(new DataParameter(key, filename, inputStream, contentType));
    }

    public void addDataParameter(String key, String filename, ResourceProvider<InputStream> inputStreamProvider, String contentType) {
        this.data.add(new DataParameter(key, filename, inputStreamProvider, contentType));
    }

    public void addDataParameters(Map<String, ?> data) {
        Args.notNull(data, "Data map");
        for (Map.Entry<String, ?> entry : data.entrySet()) {
            this.addDataParameter(entry.getKey(), entry.getValue());
        }
    }

    public void addDataParameter(String key, String filename, InputStream inputStream) {
        this.addDataParameter(key, filename, inputStream, null);
    }

    public void addDataParameter(String key, String filename, ResourceProvider<InputStream> inputStreamProvider) {
        this.addDataParameter(key, filename, inputStreamProvider, null);
    }

    public DataParameter getFirstDataParameter(String key) {
        Args.notEmpty(key, "Data key must not be empty");
        for (DataParameter param : this.data) {
            if (!param.getName().equals(key)) continue;
            return param;
        }
        return null;
    }

    public final void addDataParameters(Collection<DataParameter> data) {
        Args.notNull(data, "Data collection");
        for (DataParameter entry : data) {
            this.data.add(entry);
        }
    }

    public final void clearDataParameters() {
        this.data.clear();
    }

    public final void setProxy(Proxy proxy) {
        this.setProxy(proxy, null, 0, null, null);
    }

    public final void setProxy(Proxy proxy, String user) {
        this.setProxy(proxy, null, 0, user, null);
    }

    public final void setProxy(Proxy proxy, String user, char[] password) {
        this.setProxy(proxy, null, 0, user, password);
    }

    public final void setProxy(String host, int port) {
        this.setProxy(host, port, null, null);
    }

    public final void setProxy(String host, int port, String user) {
        this.setProxy(host, port, user, null);
    }

    public final void setProxy(String host, int port, String user, char[] password) {
        this.setProxy((Proxy)null, host, port, user, password);
    }

    private final void setProxy(Proxy proxy, String host, int port, String user, char[] password) {
        if (proxy == null) {
            Args.positive(port, "Proxy port");
            Args.notBlank(host, "Proxy host");
            this.proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(host, port));
        } else {
            this.proxy = proxy;
        }
        this.proxyUser = user;
        this.proxyPassword = password == null ? null : (char[])password.clone();
    }

    @UI
    public final void setProxy(Proxy.Type proxyType, String host, int port, String user, char[] password) {
        Proxy proxy = new Proxy(proxyType, new InetSocketAddress(host, port));
        this.setProxy(proxy, host, port, user, password);
    }

    public final String getProxyUser() {
        return this.proxyUser;
    }

    public final char[] getProxyPassword() {
        return this.proxyPassword;
    }

    public final Proxy getProxy() {
        return this.proxy;
    }

    @UI
    public final void setCharset(String charset) {
        this.charset = charset == null ? null : Charset.forName(charset);
    }

    public final void setCharset(Charset charset) {
        this.charset = charset;
    }

    public final Charset getCharset() {
        return this.charset;
    }

    public final String getCharsetName() {
        if (this.charset == null) {
            return null;
        }
        return this.charset.name();
    }

    public final boolean isIgnoreHttpErrors() {
        return this.ignoreHttpErrors;
    }

    @UI
    public final void setIgnoreHttpErrors(boolean ignoreHttpErrors) {
        this.ignoreHttpErrors = ignoreHttpErrors;
    }

    public final SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public final void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public final HttpRequest clone() {
        try {
            HttpRequest clone = (HttpRequest)super.clone();
            clone.url = this.url.clone();
            clone.cookies = new LinkedHashMap(this.cookies);
            clone.headers = new LinkedHashMap();
            for (Map.Entry e : this.headers.entrySet()) {
                ArrayList values = (ArrayList)e.getValue();
                if (values != null) {
                    values = new ArrayList(values);
                }
                clone.headers.put(e.getKey(), values);
            }
            clone.data = new ArrayList<DataParameter>();
            for (DataParameter entry : this.data) {
                clone.data.add(entry.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Could not clone", e);
        }
    }

    private void printMap(StringBuilder out, String title, Map<?, ?> map) {
        out.append("\n+----[ ").append(title).append(" ]-----");
        if (map.isEmpty()) {
            out.append("\n| N/A");
        } else {
            for (Map.Entry<?, ?> header : map.entrySet()) {
                out.append("\n| ");
                out.append(header.getKey()).append(" = ").append(header.getValue());
            }
        }
    }

    public final String printDetails() {
        StringBuilder out = new StringBuilder();
        out.append("+----[ ").append((Object)this.requestMethod).append(" ]-----\n| ");
        out.append(this.getUrl());
        this.printMap(out, "cookies", this.cookies);
        this.printMap(out, "headers", this.headers);
        out.append("\n+----[ data ]-----");
        if (this.data.isEmpty()) {
            out.append("\n| N/A");
        } else {
            for (DataParameter entry : this.data) {
                out.append("\n| ").append(entry.getName()).append(" = ");
                String value = String.valueOf(entry.getValue());
                if (value.length() > 100) {
                    out.append(value, 0, 100);
                    out.append("...");
                    continue;
                }
                out.append(value);
            }
        }
        out.append("\n+-----------------\n");
        return out.toString();
    }

    public final String toString() {
        return (Object)((Object)this.requestMethod) + " - " + this.getUrl();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequest that = (HttpRequest)o;
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        if (this.requestBody != null ? !this.requestBody.equals(that.requestBody) : that.requestBody != null) {
            return false;
        }
        if (this.requestMethod != that.requestMethod) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) {
            return false;
        }
        return ((Object)this.data).equals(that.data);
    }

    public final int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.requestMethod != null ? this.requestMethod.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (this.data != null ? ((Object)this.data).hashCode() : 0);
        result = 31 * result + (this.requestBody != null ? this.requestBody.hashCode() : 0);
        return result;
    }
}

