/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api.net;

import com.univocity.api.common.Utils;
import com.univocity.api.net.RequestMethod;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class HttpMessage {
    protected RequestMethod requestMethod = RequestMethod.GET;
    protected LinkedHashMap<String, List<String>> headers = new LinkedHashMap();
    protected LinkedHashMap<String, String> cookies = new LinkedHashMap();

    public final Map<String, String> getHeaders() {
        return Utils.joinValues(this.headers, ", ");
    }

    public final boolean hasHeader(String name) {
        Map.Entry<String, List<String>> entry = Utils.getEntryCaseInsensitive(this.headers, name);
        return entry != null;
    }

    public final Map<String, List<String>> getMultiHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public final String getHeaderValue(String header) {
        List<String> values = Utils.getValueCaseInsensitive(this.headers, header);
        if (values == null) {
            return null;
        }
        return Utils.join(values, ", ");
    }

    public final List<String> getHeaderValues(String header) {
        List<String> values = Utils.getValueCaseInsensitive(this.headers, header);
        if (values == null) {
            return null;
        }
        return values;
    }

    public final Map<String, String> getCookies() {
        return Collections.unmodifiableMap(this.cookies);
    }

    public final RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public final boolean isKeepAliveEnabled() {
        String value = this.getHeaderValue("Connection");
        return value == null || "keep-alive".equalsIgnoreCase(value);
    }

    public final String getUserAgent() {
        return this.getHeaderValue("User-Agent");
    }

    public final String getReferrer() {
        return this.getHeaderValue("Referer");
    }

    public final String getCookieValue(String name) {
        return this.cookies.get(name);
    }

    public final boolean hasCookie(String name) {
        return this.cookies.containsKey(name);
    }

    public final boolean hasHeaderWithValue(String name, String value) {
        List<String> values = this.getHeaderValues(name);
        if (values != null) {
            for (String candidate : values) {
                if (!value.equalsIgnoreCase(candidate)) continue;
                return true;
            }
        }
        return false;
    }
}

