/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api.net;

import com.univocity.api.common.Args;
import com.univocity.api.io.FileProvider;
import com.univocity.api.io.ResourceProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public final class DataParameter
implements Cloneable {
    private String name;
    private String value;
    private ResourceProvider<InputStream> uploadStream;
    private String contentType = "application/octet-stream";

    public DataParameter(String name, String value) {
        Args.notBlank(name, "Data parameter name");
        Args.notNull(value, "Value of data parameter '" + name + "'");
        this.name = name;
        this.value = value;
    }

    public DataParameter(String name, String filename, FileProvider fileToUpload) {
        this(name, filename, fileToUpload, null);
    }

    public DataParameter(String name, String filename, InputStream uploadStream) {
        this(name, filename, uploadStream, null);
    }

    public DataParameter(String name, String filename, ResourceProvider<InputStream> uploadStream) {
        this(name, filename, uploadStream, null);
    }

    public DataParameter(final String name, String filename, final FileProvider fileToUpload, String contentType) {
        this(name, filename, new ResourceProvider<InputStream>(){

            @Override
            public InputStream getResource() {
                try {
                    return new FileInputStream(new File(fileToUpload.getFilePath()));
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException("Can't find file '" + fileToUpload.getFilePath() + "' associated with data parameter '" + name + "'", e);
                }
            }
        }, contentType);
    }

    public DataParameter(String name, String filename, final InputStream uploadStream, String contentType) {
        this(name, filename, new ResourceProvider<InputStream>(){

            @Override
            public InputStream getResource() {
                return uploadStream;
            }
        }, contentType);
    }

    public DataParameter(String name, String filename, ResourceProvider<InputStream> uploadStream, String contentType) {
        Args.notBlank(name, "Data parameter name");
        Args.notBlank(filename, "Filename associated with data parameter '" + name + "'");
        Args.notNull(uploadStream, "Input stream provider of upload file '" + filename + "' associated with data parameter '" + name + "'");
        this.name = name;
        this.value = filename;
        this.uploadStream = uploadStream;
        if (Args.isNotBlank(contentType)) {
            this.contentType = contentType;
        }
    }

    public final String getName() {
        return this.name;
    }

    public final String getValue() {
        return this.value;
    }

    public final ResourceProvider<InputStream> getUploadStream() {
        return this.uploadStream;
    }

    public String toString() {
        if (this.value != null && this.value.length() > 100) {
            return this.name + "=" + this.value.substring(0, 100) + "...";
        }
        return this.name + "=" + this.value;
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final DataParameter clone() {
        try {
            return (DataParameter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Error cloning " + this, e);
        }
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataParameter that = (DataParameter)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.uploadStream != null ? !this.uploadStream.equals(that.uploadStream) : that.uploadStream != null) {
            return false;
        }
        return this.contentType != null ? this.contentType.equals(that.contentType) : that.contentType == null;
    }

    public final int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.uploadStream != null ? this.uploadStream.hashCode() : 0);
        result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
        return result;
    }
}

