/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api.io;

import com.univocity.api.common.Args;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimiter {
    private static final Logger log = LoggerFactory.getLogger(RateLimiter.class);
    private long lastCallTime;
    private long waitTimeAdjustment;
    private long interval;
    private final Object callLock = new Object();
    private final AtomicInteger callWaitingCount = new AtomicInteger();
    private final String name;

    public RateLimiter(long interval) {
        this(null, interval);
    }

    public RateLimiter(String name, long interval) {
        Args.positiveOrZero(interval, "Interval");
        this.interval = interval;
        this.name = Args.isBlank(name) ? "" : name.trim();
    }

    public String getName() {
        return this.name;
    }

    public final long getInterval() {
        return this.interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterval(long interval) {
        Args.positiveOrZero(interval, "Interval");
        this.interval = interval;
        if (interval == 0L) {
            Object object = this.callLock;
            synchronized (object) {
                this.callLock.notifyAll();
            }
        }
    }

    public final long getWaitingCount() {
        return this.callWaitingCount.get();
    }

    public final long waitAndGo(long timeout) throws TimeoutException {
        return this.waitAndGo("operation", timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long waitAndGo(String action, long timeout) throws TimeoutException {
        long start = 0L;
        if (timeout > 0L) {
            start = System.currentTimeMillis();
        }
        this.callWaitingCount.incrementAndGet();
        Object object = this.callLock;
        synchronized (object) {
            long time = System.currentTimeMillis();
            if (timeout > 0L && time - start > timeout) {
                throw new TimeoutException(this.name + " rate limiter: " + action + " timed out after " + (time - start) + "ms");
            }
            this.doWait(time, action);
        }
        return this.callWaitingCount.decrementAndGet();
    }

    public final long waitAndGo() {
        return this.waitAndGo("proceeding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long waitAndGo(String action) {
        this.callWaitingCount.incrementAndGet();
        Object object = this.callLock;
        synchronized (object) {
            this.doWait(System.currentTimeMillis(), action);
        }
        return this.callWaitingCount.decrementAndGet();
    }

    private void doWait(long currentTime, String action) {
        long waitTime = this.lastCallTime == 0L ? 0L : this.interval + this.waitTimeAdjustment - (currentTime - this.lastCallTime);
        this.waitTimeAdjustment = 0L;
        if (waitTime > 0L) {
            try {
                log.debug("{} rate limiter active: waiting {} ms before {}", new Object[]{this.name, waitTime, action});
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.lastCallTime = System.currentTimeMillis();
    }

    public final void decreaseWaitTime(long timeToDecrease) {
        Args.positive(timeToDecrease, "Time to decrease");
        this.waitTimeAdjustment = -timeToDecrease;
    }

    public final void increaseWaitTime(long timeToIncrease) {
        Args.positive(timeToIncrease, "Time to increase");
        this.waitTimeAdjustment = timeToIncrease;
    }
}

