/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api.io;

import com.univocity.api.io.ReaderProvider;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public abstract class InputQueue<T>
extends ReaderProvider {
    private final Map<T, Map<String, Object>> variables = new HashMap<T, Map<String, Object>>();
    private final Queue<T> inputQueue = new LinkedList<T>();
    private Map<String, Object> currentVariables = null;
    private T lastEntry;

    public final boolean isEmpty() {
        return this.inputQueue.isEmpty();
    }

    public final int size() {
        return this.inputQueue.size();
    }

    public final T peek() {
        return this.inputQueue.peek();
    }

    protected final void offer(T input) {
        this.inputQueue.offer(input);
        this.lastEntry = input;
    }

    public void assignVariableToLastEntry(String variable, Object value) {
        if (this.lastEntry == null) {
            throw new IllegalArgumentException("Can't assign value '" + value + "' to variable '" + variable + "' bound to last entry of input queue. Input queue is empty.");
        }
        this.assignVariableToEntry(this.lastEntry, variable, value);
    }

    public void assignVariablesToLastEntry(Map<String, Object> variables) {
        if (this.lastEntry == null) {
            throw new IllegalArgumentException("Can't assign variables " + variables + " to last entry of input queue. Input queue is empty.");
        }
        for (Map.Entry<String, Object> e : variables.entrySet()) {
            this.assignVariableToEntry(this.lastEntry, e.getKey(), e.getValue());
        }
    }

    private void assignVariableToEntry(T entry, String variable, Object value) {
        Map<String, Object> entryVars = this.variables.get(entry);
        if (entryVars == null) {
            entryVars = new HashMap<String, Object>();
            this.variables.put(entry, entryVars);
        }
        entryVars.put(variable, value);
    }

    @Override
    public final Reader getResource() {
        T input = this.inputQueue.poll();
        if (input == null) {
            throw new IllegalStateException("No input to process");
        }
        this.currentVariables = this.variables.remove(input);
        return this.open(input);
    }

    public Object readVariable(String variable) {
        return this.getCurrentVariables().get(variable);
    }

    public <O> O readVariable(String variable, O defaultValue) {
        Object out = this.getCurrentVariables().get(variable);
        if (out == null) {
            return defaultValue;
        }
        return (O)out;
    }

    public <O> O readVariable(String variable, Class<O> type) {
        Object out = this.getCurrentVariables().get(variable);
        if (out != null) {
            return type.cast(out);
        }
        return null;
    }

    public Map<String, Object> getCurrentVariables() {
        if (this.currentVariables == null) {
            return Collections.emptyMap();
        }
        return this.currentVariables;
    }

    protected abstract Reader open(T var1);
}

