/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api.io;

import com.univocity.api.common.Args;
import java.io.File;
import java.nio.charset.Charset;

public final class FileProvider {
    private final File file;
    private final Charset encoding;
    private final String filePath;

    public FileProvider(File file) {
        this(file, (Charset)null);
    }

    public FileProvider(File file, String encoding) {
        this(file, FileProvider.getEncoding(encoding));
    }

    public FileProvider(File file, Charset encoding) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.encoding = FileProvider.getEncoding(encoding);
        this.file = file;
        this.filePath = file.getAbsolutePath();
    }

    public FileProvider(String file) {
        this(file, (Charset)null);
    }

    public FileProvider(String file, String encoding) {
        this(file, FileProvider.getEncoding(encoding));
    }

    public FileProvider(String filePath, Charset encoding) {
        if (filePath == null || filePath.trim().isEmpty()) {
            throw new IllegalArgumentException("File path cannot be null or empty");
        }
        this.encoding = FileProvider.getEncoding(encoding);
        this.file = null;
        this.filePath = Args.replaceSystemProperties(filePath).replace('\\', '/');
    }

    private static final Charset getEncoding(String encoding) {
        if (encoding == null) {
            return Charset.defaultCharset();
        }
        return Charset.forName(encoding);
    }

    private static final Charset getEncoding(Charset encoding) {
        if (encoding == null) {
            return Charset.defaultCharset();
        }
        return encoding;
    }

    public final File getFile() {
        return this.file;
    }

    public final Charset getEncoding() {
        return this.encoding;
    }

    public final String getFilePath() {
        return this.filePath;
    }

    public final String toString() {
        return this.filePath + " (" + this.encoding + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileProvider that = (FileProvider)o;
        return this.filePath.equals(that.filePath);
    }

    public int hashCode() {
        return this.filePath.hashCode();
    }
}

