/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api.config;

import com.univocity.api.common.Args;
import com.univocity.api.config.OrderedProperties;
import com.univocity.api.exception.IllegalConfigurationException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PropertyBasedConfiguration {
    protected final Properties properties;
    private final Map<String, String> values = new LinkedHashMap<String, String>();

    public PropertyBasedConfiguration(InputStream inputProperties) throws IllegalConfigurationException {
        this((Closeable)inputProperties);
    }

    public PropertyBasedConfiguration(Reader inputProperties) throws IllegalConfigurationException {
        this((Closeable)inputProperties);
    }

    public PropertyBasedConfiguration(File inputProperties) throws IllegalConfigurationException {
        this(PropertyBasedConfiguration.getFileReader(inputProperties));
    }

    public PropertyBasedConfiguration(String ... configurationPaths) throws IllegalConfigurationException {
        this(PropertyBasedConfiguration.openConfiguration(configurationPaths));
    }

    private PropertyBasedConfiguration(Closeable inputProperties) throws IllegalConfigurationException {
        Args.notNull(inputProperties, "Properties file input");
        this.properties = new OrderedProperties();
        try {
            if (inputProperties instanceof InputStream) {
                this.properties.load((InputStream)inputProperties);
            } else if (inputProperties instanceof Reader) {
                this.properties.load((Reader)inputProperties);
            }
        }
        catch (Exception e) {
            throw new IllegalConfigurationException("Error loading configuration from properties " + this.getPropertiesDescription(), e);
        }
        finally {
            try {
                inputProperties.close();
            }
            catch (Exception e) {}
        }
        Enumeration<?> keys = this.properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String parent = null;
            int lastDot = key.lastIndexOf(46);
            if (lastDot > 0) {
                parent = key.substring(0, lastDot);
            }
            this.values.put(key, this.replaceProperty(this.properties.getProperty(key), parent));
        }
    }

    private static InputStream openConfiguration(String ... pathsToTry) {
        Args.notEmpty(pathsToTry, "List of paths to look for a properties file");
        for (String path : pathsToTry) {
            try {
                return new FileInputStream(path);
            }
            catch (Exception e) {
                InputStream out = PropertyBasedConfiguration.class.getResourceAsStream(path);
                if (out != null) {
                    return out;
                }
                if (path.startsWith("/") || (out = PropertyBasedConfiguration.class.getResourceAsStream("/" + path)) == null) continue;
                return out;
            }
        }
        throw new IllegalConfigurationException("Could not load a properties file from any of the given paths: " + Arrays.toString(pathsToTry));
    }

    private static Reader getFileReader(File file) {
        Args.notNull(file, "Properties file");
        try {
            return new FileReader(file);
        }
        catch (Exception ex) {
            throw new IllegalConfigurationException("Error loading properties from file " + file.getAbsolutePath(), ex);
        }
    }

    public final String toString() {
        StringBuilder out = new StringBuilder(this.getPropertiesDescription());
        for (Map.Entry<String, String> e : this.values.entrySet()) {
            out.append('\n');
            out.append('\t');
            out.append(e.getKey());
            out.append('=');
            out.append(e.getValue());
        }
        return out.toString();
    }

    protected String getPropertiesDescription() {
        return "properties file";
    }

    protected final String replaceVariables(String s, String variable, String value) {
        int end;
        variable = "${" + variable + "}";
        StringBuilder out = new StringBuilder();
        int start = 0;
        while ((end = s.indexOf(variable, start)) != -1) {
            out.append(s.substring(start, end)).append(value);
            start = end + variable.length();
        }
        out.append(s.substring(start));
        return out.toString();
    }

    protected final List<String> listVariables(String s) {
        int end;
        int start;
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < s.length() - 1 && (start = s.indexOf("${", i)) >= 0 && (end = s.indexOf("}", start += 2)) >= 0) {
            list.add(s.substring(start, end));
            i = end + 1;
        }
        return list;
    }

    public final void setSystemProperty(String property) {
        this.setSystemProperty(property, false);
    }

    public final void setSystemProperty(String property, boolean override) {
        String value = System.getProperty(property);
        if ((Args.isBlank(value) || override) && Args.isNotBlank(value = this.getProperty(property))) {
            System.setProperty(property, value);
        }
    }

    private String replaceProperty(String value, String parentProperty) {
        if (Args.isBlank(value)) {
            return null;
        }
        String originalValue = value;
        for (String key : this.listVariables(value)) {
            String var;
            boolean found = false;
            if (this.values.containsKey(key)) {
                var = this.values.get(key);
                found = true;
            } else if ("user.home".equals(key)) {
                var = this.normalizeFilePath(System.getProperty("user.home"));
                found = true;
            } else {
                var = System.getProperty(key);
            }
            if (var == null && parentProperty != null) {
                String parent = parentProperty;
                while (true) {
                    if (found = this.values.containsKey(parent + "." + key)) {
                        var = this.values.get(parent + "." + key);
                        break;
                    }
                    int dot = parent.lastIndexOf(46);
                    if (dot <= 0) break;
                    parent = parent.substring(0, dot);
                }
            }
            if (var == null && !found) {
                throw new IllegalConfigurationException("Invalid configuration! No value defined for ${" + key + "} in " + originalValue);
            }
            value = this.replaceVariables(value, key, var);
        }
        return value;
    }

    public final String getProperty(String property, String defaultValue) {
        if (!this.values.containsKey(property)) {
            return defaultValue;
        }
        return this.values.get(property);
    }

    public final String getProperty(String property) throws IllegalConfigurationException {
        if (!this.values.containsKey(property)) {
            throw new IllegalConfigurationException("Invalid configuration in " + this.getPropertiesDescription() + ". Property '" + property + "' could not be found.");
        }
        return this.values.get(property);
    }

    public final String getProperty(String property, String ... keyValuePairs) throws IllegalConfigurationException {
        String previous;
        String result = previous = this.getProperty(property);
        if (previous != null && keyValuePairs.length > 0) {
            do {
                previous = result;
                for (int i = 0; i < keyValuePairs.length; i += 2) {
                    String key = keyValuePairs[i];
                    String value = keyValuePairs[i + 1];
                    result = result.replace("!{" + key + "}", value);
                }
            } while (!result.equals(previous));
        }
        return result;
    }

    public final String normalizeFilePath(String filePath) {
        if (filePath == null) {
            throw new IllegalConfigurationException("File path undefined");
        }
        if (!(filePath = filePath.replaceAll("\\\\", "/")).endsWith("/")) {
            filePath = filePath + "/";
        }
        return filePath;
    }

    public final File getValidatedFile(String pathToFile, boolean mandatory, boolean validateRead, boolean validateWrite, boolean create) throws IllegalConfigurationException {
        return this.getValidatedPath(pathToFile, null, false, mandatory, validateRead, validateWrite, create, new String[0]);
    }

    public final File getValidatedDirectory(String pathToDir, boolean mandatory, boolean validateRead, boolean validateWrite, boolean create) throws IllegalConfigurationException {
        return this.getValidatedPath(pathToDir, null, true, mandatory, validateRead, validateWrite, create, new String[0]);
    }

    private File getValidatedPath(String property, File defaultFile, boolean isDirectory, boolean mandatory, boolean validateRead, boolean validateWrite, boolean create, String ... keyValuePairs) throws IllegalConfigurationException {
        String description;
        String path = this.getProperty(property, keyValuePairs);
        String string = description = isDirectory ? "Directory" : "File";
        if (path == null) {
            if (mandatory) {
                throw new IllegalConfigurationException(description + " path undefined. Property '" + property + "' must be set with a valid path.");
            }
            return defaultFile;
        }
        path = this.normalizeFilePath(path);
        File file = new File(path);
        String baseErrorMessage = ". Path defined by property '" + property + "' is: " + path;
        if (create && !file.exists()) {
            boolean created;
            if (isDirectory) {
                created = file.mkdirs();
            } else {
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                try {
                    created = file.createNewFile();
                }
                catch (IOException e) {
                    throw new IllegalConfigurationException("Cannot create " + description + baseErrorMessage, e);
                }
            }
            if (!created) {
                throw new IllegalConfigurationException("Cannot create " + description + baseErrorMessage);
            }
        }
        if (validateRead || validateWrite) {
            if (!file.exists()) {
                throw new IllegalConfigurationException(description + " does not exist" + baseErrorMessage);
            }
            if (validateRead && !file.canRead()) {
                throw new IllegalConfigurationException(description + " can't be read" + baseErrorMessage);
            }
            if (validateWrite && !file.canWrite()) {
                throw new IllegalConfigurationException(description + " is not writable" + baseErrorMessage);
            }
        }
        return file;
    }

    public final File getDirectory(String property, boolean validateRead, boolean validateWrite, boolean create, String ... keyValuePairs) throws IllegalConfigurationException {
        return this.getDirectory(property, true, validateRead, validateWrite, create, keyValuePairs);
    }

    public final File getDirectory(String property, boolean mandatory, boolean validateRead, boolean validateWrite, boolean create, String ... keyValuePairs) throws IllegalConfigurationException {
        return this.getValidatedPath(property, null, true, mandatory, validateRead, validateWrite, create, keyValuePairs);
    }

    public final File getDirectory(String property, File defaultDir, boolean validateRead, boolean validateWrite, String ... keyValuePairs) throws IllegalConfigurationException {
        return this.getValidatedPath(property, defaultDir, true, false, validateRead, validateWrite, false, keyValuePairs);
    }

    public final File getFile(String property, boolean validateRead, boolean validateWrite, boolean create, String ... keyValuePairs) throws IllegalConfigurationException {
        return this.getValidatedPath(property, null, false, true, validateRead, validateWrite, create, keyValuePairs);
    }

    public final File getFile(String property, boolean mandatory, boolean validateRead, boolean validateWrite, boolean create, String ... keyValuePairs) throws IllegalConfigurationException {
        return this.getValidatedPath(property, null, false, mandatory, validateRead, validateWrite, create, keyValuePairs);
    }

    public final File getFile(String property, File defaultFile, boolean validateRead, boolean validateWrite, String ... keyValuePairs) throws IllegalConfigurationException {
        return this.getValidatedPath(property, defaultFile, false, false, validateRead, validateWrite, false, keyValuePairs);
    }

    public final Integer getInteger(String property) {
        String value = this.getProperty(property);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception ex) {
            throw new IllegalConfigurationException("Cannot convert value of property {}" + property + " to a valid integer number. Got: " + value);
        }
    }

    public final Integer getInteger(String property, Integer defaultValue) {
        if (!this.values.containsKey(property)) {
            return defaultValue;
        }
        return this.getInteger(property);
    }

    public final List<String> getList(String property) {
        return this.getList(property, ",");
    }

    public final List<String> getList(String property, String separator) {
        String value = this.getProperty(property);
        ArrayList<String> out = new ArrayList<String>();
        if (value == null) {
            return out;
        }
        for (String e : value.split(separator)) {
            if ((e = e.trim()).length() <= 0) continue;
            out.add(e);
        }
        return out;
    }

    public final boolean getBoolean(String property, boolean defaultValue) {
        if (!this.values.containsKey(property)) {
            return defaultValue;
        }
        return this.getBoolean(property);
    }

    public final boolean getBoolean(String property) {
        String value = this.getProperty(property);
        return Boolean.valueOf(value);
    }
}

