/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Utils {
    public static final String join(Iterable<?> values, String separator) {
        if (values == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(64);
        for (Object value : values) {
            if (value == null) continue;
            if (out.length() != 0) {
                out.append(separator);
            }
            out.append(value);
        }
        return out.toString();
    }

    public static final <K, V extends Iterable> Map<K, String> joinValues(Map<K, V> map, String separator) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<K, String> out = new LinkedHashMap<K, String>();
        for (Map.Entry<K, V> e : map.entrySet()) {
            out.put(e.getKey(), Utils.join((Iterable)e.getValue(), separator));
        }
        return out;
    }

    public static final <V> Map.Entry<String, V> getEntryCaseInsensitive(Map<String, V> map, String key) {
        if (key != null) {
            key = key.toLowerCase(Locale.ENGLISH);
        }
        for (Map.Entry<String, V> entry : map.entrySet()) {
            String k = entry.getKey();
            if (!(key == null ? k == null : k != null && key.equals(k.toLowerCase(Locale.ENGLISH)))) continue;
            return entry;
        }
        return null;
    }

    public static final <V> V getValueCaseInsensitive(Map<String, V> map, String key) {
        Map.Entry<String, V> e = Utils.getEntryCaseInsensitive(map, key);
        if (e == null) {
            return null;
        }
        return e.getValue();
    }

    public static final <V> void putValueCaseInsensitive(Map<String, List<V>> map, String key, V value, boolean add) {
        List<V> values = Utils.getValueCaseInsensitive(map, key);
        if (values == null) {
            values = new ArrayList<V>();
            map.put(key, values);
        } else if (!add) {
            values.clear();
        }
        values.add(value);
    }
}

