/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api.common;

import com.univocity.api.common.Args;
import com.univocity.api.common.NotificationHandler;

public abstract class TimedNotificationHandler<T>
implements NotificationHandler<T> {
    private final long notificationInterval;
    private long previousNotification = 0L;

    public TimedNotificationHandler(long notificationInterval) {
        Args.positive(notificationInterval, "Notification interval");
        this.notificationInterval = notificationInterval;
    }

    @Override
    public final void notify(T notification, boolean lastNotification) {
        if (this.notificationInterval > 0L && !lastNotification) {
            long time = System.currentTimeMillis();
            if (time - this.previousNotification > this.notificationInterval) {
                this.onNotification(notification, false);
                this.previousNotification = time;
            }
        } else {
            this.onNotification(notification, lastNotification);
        }
    }

    protected abstract void onNotification(T var1, boolean var2);
}

