/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api.common;

import com.univocity.api.common.Args;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ParameterizedString
implements Cloneable {
    private final String string;
    private Parameter[] parameters;
    private final Set<String> parameterNames = new TreeSet<String>();
    private TreeMap<String, Object> parameterValues;
    private String[] nonParameterSections;
    private StringBuilder tmp;
    private final String openBracket;
    private final String closeBracket;
    private String result = null;
    private Object defaultValue = null;
    private boolean convertDefaultValueToNull = true;

    public ParameterizedString(String string, String openBracket, String closeBracket) {
        Args.notBlank(string, "Input string");
        Args.notBlank(openBracket, "Open bracket");
        Args.notBlank(closeBracket, "Close bracket");
        this.parameterValues = new TreeMap();
        this.openBracket = openBracket;
        this.closeBracket = closeBracket;
        this.string = string;
        this.tmp = new StringBuilder((int)((double)string.length() * 1.5));
        this.collectParameters();
    }

    public ParameterizedString(String string) {
        this(string, "{", "}");
    }

    private void collectParameters() {
        int openBracketIndex;
        ArrayList<String> nonParameterSections = new ArrayList<String>();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        int x = 0;
        int nonParameterIndexStart = 0;
        while ((openBracketIndex = this.string.indexOf(this.openBracket, x)) >= 0) {
            if (openBracketIndex != 0 && openBracketIndex == nonParameterIndexStart) {
                int errorPos = openBracketIndex;
                StringBuilder errorMsg = new StringBuilder("At least one character between parameters is required.\nNo separation found after:\n'");
                errorMsg.append(this.string).append("'\n");
                for (int i = 0; i < errorPos; ++i) {
                    errorMsg.append('.');
                }
                errorMsg.append('^');
                throw new IllegalArgumentException(errorMsg.toString());
            }
            int closeBracketIndex = this.string.indexOf(this.closeBracket, openBracketIndex);
            if (closeBracketIndex > 0) {
                int nextOpenBracket;
                do {
                    if ((nextOpenBracket = this.string.indexOf(this.openBracket, openBracketIndex + this.openBracket.length())) <= 0 || nextOpenBracket >= closeBracketIndex) continue;
                    openBracketIndex = nextOpenBracket;
                } while (nextOpenBracket > 0 && nextOpenBracket < closeBracketIndex);
                x = closeBracketIndex;
                String nonParameterSection = this.string.substring(nonParameterIndexStart, openBracketIndex);
                if (!nonParameterSection.isEmpty()) {
                    nonParameterSections.add(nonParameterSection);
                }
                nonParameterIndexStart = closeBracketIndex + this.closeBracket.length();
                int start = openBracketIndex + this.openBracket.length();
                if (this.hasWhitespace(start, closeBracketIndex)) continue;
                String parameterizedName = this.string.substring(start, closeBracketIndex);
                Parameter parameter = new Parameter(parameterizedName, openBracketIndex, closeBracketIndex + this.closeBracket.length());
                parameters.add(parameter);
                if (openBracketIndex == 0) {
                    nonParameterSections.add("");
                }
                this.parameterNames.add(parameter.name);
                continue;
            }
            x = openBracketIndex + this.openBracket.length();
        }
        if (nonParameterIndexStart < this.string.length()) {
            nonParameterSections.add(this.string.substring(nonParameterIndexStart));
        }
        this.nonParameterSections = nonParameterSections.toArray(new String[0]);
        this.parameters = parameters.toArray(new Parameter[0]);
    }

    private boolean hasWhitespace(int from, int to) {
        for (int i = from; i < to; ++i) {
            char ch = this.string.charAt(i);
            if (ch > ' ' && ch != ',' || ch == ' ' && (i == from || i + 1 == to)) continue;
            boolean foundComma = false;
            while (i < to) {
                ch = this.string.charAt(i);
                if (ch < ' ') {
                    return true;
                }
                if (ch == ',') {
                    foundComma = true;
                }
                ++i;
            }
            if (foundComma) continue;
            return true;
        }
        return false;
    }

    public final void set(Map<String, ?> parametersAndValues) throws IllegalArgumentException {
        if (parametersAndValues == null) {
            return;
        }
        for (Map.Entry<String, ?> e : parametersAndValues.entrySet()) {
            this.set(e.getKey(), e.getValue());
        }
    }

    public final void set(String parameter, Object value) throws IllegalArgumentException {
        this.validateParameterName(parameter);
        if (this.convertDefaultValueToNull && value != null && this.defaultValue != null && value.equals(this.defaultValue)) {
            value = null;
        }
        this.parameterValues.put(parameter, value);
        this.result = null;
    }

    public final Object get(String parameter) throws IllegalArgumentException {
        this.validateParameterName(parameter);
        return this.parameterValues.get(parameter);
    }

    private void invalidInput(String input) {
        this.clearValues();
        throw new IllegalArgumentException("The input:\n'" + input + "'\nDoes not match the parameter pattern:\n'" + this.string + "'");
    }

    public final Map<String, Object> parse(String input) {
        if (this.parameters.length == 0) {
            return Collections.emptyMap();
        }
        TreeSet<String> parsedParams = new TreeSet<String>();
        int valueStart = 0;
        int p = 0;
        for (int i = 0; i < this.nonParameterSections.length && p < this.parameters.length; ++i) {
            int valueEnd;
            String section = this.nonParameterSections[i];
            if ((valueStart = input.indexOf(section, valueStart)) == -1) {
                this.invalidInput(input);
            }
            valueStart += section.length();
            if (i + 1 < this.nonParameterSections.length) {
                String nextSection = this.nonParameterSections[i + 1];
                valueEnd = input.indexOf(nextSection, valueStart);
                if (valueEnd == -1) {
                    this.invalidInput(input);
                }
            } else {
                valueEnd = input.length();
            }
            String value = input.substring(valueStart, valueEnd);
            Parameter parameter = this.parameters[p++];
            Object existingValue = this.parameterValues.get(parameter.name);
            if (existingValue != null && !existingValue.equals(value) && parsedParams.contains(parameter.name)) {
                StringBuilder sb = new StringBuilder("Multiple values ('").append(existingValue).append("' and '").append(value).append("') found for parameter '");
                sb.append(parameter.name);
                sb.append("'\n");
                sb.append(input);
                sb.append('\n');
                int errPos = input.length() - input.length() + input.indexOf(value);
                for (int j = 0; j < errPos; ++j) {
                    sb.append('.');
                }
                sb.append('^');
                throw new IllegalArgumentException(sb.toString());
            }
            parsedParams.add(parameter.name);
            this.set(parameter.name, value);
        }
        if (this.nonParameterSections.length == 0 && this.parameters.length == 1) {
            this.set(this.parameters[0].name, input);
        }
        return this.getParameterValues();
    }

    private void validateParameterName(String parameter) {
        Args.notBlank(parameter, "Parameter name");
        if (!this.parameterNames.contains(parameter)) {
            throw new IllegalArgumentException("Parameter '" + parameter + "' not found in " + this.string + ". Available parameters: " + this.parameterNames);
        }
    }

    public final String toString() {
        return this.string;
    }

    public final String applyParameterValues() {
        if (this.result == null) {
            this.tmp.setLength(0);
            this.applyParameterValues(this.tmp);
            this.result = this.tmp.toString();
        }
        return this.result;
    }

    public final void applyParameterValues(StringBuilder out) {
        if (this.result != null) {
            out.append(this.result);
        } else {
            int initialLength = out.length();
            int lastClosedBracketIndex = 0;
            for (int i = 0; i < this.parameters.length; ++i) {
                Object parameterValue = this.parameterValues.get(this.parameters[i].name);
                if (parameterValue == null && this.defaultValue != null) {
                    parameterValue = this.defaultValue;
                }
                if (parameterValue == null) continue;
                int openBracketIndex = this.parameters[i].startPosition;
                int closedBracketIndex = this.parameters[i].endPosition;
                if (out.length() == initialLength) {
                    out.append(this.string, 0, openBracketIndex);
                } else {
                    out.append(this.string, lastClosedBracketIndex, openBracketIndex);
                }
                out.append(parameterValue);
                lastClosedBracketIndex = closedBracketIndex;
            }
            out.append(this.string, lastClosedBracketIndex, this.string.length());
        }
    }

    public final Set<String> getParameters() {
        return Collections.unmodifiableSet(this.parameterNames);
    }

    public final void clearValues() {
        this.parameterValues.clear();
        this.result = null;
    }

    public final boolean contains(String parameterName) {
        return this.parameterNames.contains(parameterName);
    }

    public final String getFormat(String parameterName) throws IllegalArgumentException {
        this.validateParameterName(parameterName);
        for (Parameter parameter : this.parameters) {
            if (!parameter.name.equals(parameterName)) continue;
            return parameter.format;
        }
        return null;
    }

    public final ParameterizedString clone() {
        try {
            ParameterizedString clone = (ParameterizedString)super.clone();
            clone.parameterValues = (TreeMap)this.parameterValues.clone();
            clone.tmp = new StringBuilder(this.tmp.capacity());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Could not clone parameterized string", e);
        }
    }

    public final Map<String, Object> getParameterValues() {
        return Collections.unmodifiableMap(this.parameterValues);
    }

    public final void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        if (defaultValue != null && !this.parameterValues.isEmpty()) {
            for (Map.Entry<String, Object> e : this.parameterValues.entrySet()) {
                if (!defaultValue.equals(e.getValue())) continue;
                e.setValue(null);
            }
        }
    }

    public final Object getDefaultValue() {
        return this.defaultValue;
    }

    public final int getIndexBeforeFirstParameter() {
        if (this.parameters.length > 0) {
            return this.parameters[0].startPosition;
        }
        return -1;
    }

    public final int getIndexAfterLastParameter() {
        if (this.parameters.length > 0) {
            return this.parameters[this.parameters.length - 1].endPosition;
        }
        return -1;
    }

    public final String getContentBeforeFirstParameter() {
        if (this.parameters.length == 0) {
            return this.string;
        }
        int index = this.getIndexBeforeFirstParameter();
        return this.string.substring(0, index);
    }

    public final String getContentAfterLastParameter() {
        if (this.parameters.length == 0) {
            return this.string;
        }
        int index = this.getIndexAfterLastParameter();
        return this.string.substring(index, this.string.length());
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterizedString that = (ParameterizedString)o;
        if (this.string != null ? !this.string.equals(that.string) : that.string != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        if (this.parameterNames != null ? !((Object)this.parameterNames).equals(that.parameterNames) : that.parameterNames != null) {
            return false;
        }
        if (this.openBracket != null ? !this.openBracket.equals(that.openBracket) : that.openBracket != null) {
            return false;
        }
        if (this.closeBracket != null ? !this.closeBracket.equals(that.closeBracket) : that.closeBracket != null) {
            return false;
        }
        return this.parameterValues != null ? this.parameterValues.equals(that.parameterValues) : that.parameterValues == null;
    }

    public final int hashCode() {
        int result = this.string != null ? this.string.hashCode() : 0;
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        result = 31 * result + (this.parameterNames != null ? ((Object)this.parameterNames).hashCode() : 0);
        result = 31 * result + (this.openBracket != null ? this.openBracket.hashCode() : 0);
        result = 31 * result + (this.closeBracket != null ? this.closeBracket.hashCode() : 0);
        result = 31 * result + (this.parameterValues != null ? this.parameterValues.hashCode() : 0);
        return result;
    }

    public final boolean getConvertDefaultValueToNull() {
        return this.convertDefaultValueToNull;
    }

    public final void setConvertDefaultValueToNull(boolean convertDefaultValueToNull) {
        this.convertDefaultValueToNull = convertDefaultValueToNull;
    }

    private static final class Parameter {
        final String name;
        final int startPosition;
        final int endPosition;
        final String format;

        Parameter(String name, int startPosition, int endPosition) {
            name = name.trim();
            if (name.contains(",")) {
                this.name = name.substring(0, name.indexOf(",")).trim();
                this.format = name.substring(name.indexOf(",") + 1).trim();
                if (this.format.length() == 0) {
                    throw new IllegalArgumentException("Expected formatting parameter after ',' in '" + name + "'");
                }
            } else {
                this.name = name;
                this.format = null;
            }
            this.startPosition = startPosition;
            this.endPosition = endPosition;
        }

        public final String toString() {
            return "Parameter{name='" + this.name + '\'' + ", startPosition=" + this.startPosition + ", endPosition=" + this.endPosition + ", format='" + this.format + '\'' + '}';
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            if (this.startPosition != parameter.startPosition) {
                return false;
            }
            if (this.endPosition != parameter.endPosition) {
                return false;
            }
            if (!this.name.equals(parameter.name)) {
                return false;
            }
            return this.format != null ? this.format.equals(parameter.format) : parameter.format == null;
        }

        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.startPosition;
            result = 31 * result + this.endPosition;
            result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
            return result;
        }
    }
}

