/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api.common;

import java.io.File;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;

public class Args {
    protected Args() {
    }

    public static final void notNull(Object o, String fieldName) {
        if (o == null) {
            throw new IllegalArgumentException(fieldName + " cannot be null");
        }
    }

    public static final void positive(Number o, String fieldName) {
        Args.notNull(o, fieldName);
        if (Integer.valueOf(o.intValue()).compareTo(0) <= 0) {
            throw new IllegalArgumentException(fieldName + " must be positive. Got " + o);
        }
    }

    public static final void positiveOrZero(Number o, String fieldName) {
        Args.notNull(o, fieldName);
        if (Double.valueOf(o.doubleValue()).compareTo(0.0) < 0) {
            throw new IllegalArgumentException(fieldName + " must be a positive number or zero. Got " + o);
        }
    }

    public static <T> void notEmpty(T[] sequence, String fieldName) {
        Args.notNull(sequence, fieldName);
        if (sequence.length == 0) {
            throw new IllegalArgumentException(fieldName + " cannot be empty");
        }
        for (T element : sequence) {
            if (element == null) {
                throw new IllegalArgumentException("Illegal " + fieldName + " list. Null elements are not allowed. Got " + Arrays.toString(sequence));
            }
            if (!(element instanceof String) || !element.toString().trim().isEmpty()) continue;
            throw new IllegalArgumentException("Illegal " + fieldName + " list. Blank elements are not allowed. Got " + Arrays.toString(sequence));
        }
    }

    public static void notEmpty(Collection<?> field, String fieldName) {
        Args.notNull(field, fieldName);
        if (field.isEmpty()) {
            throw new IllegalArgumentException(fieldName + " cannot be empty");
        }
    }

    public static <T> void noneEmpty(Collection<T> elements, String fieldName) {
        Args.notNull(elements, fieldName);
        if (elements.isEmpty()) {
            throw new IllegalArgumentException(fieldName + " cannot be empty");
        }
        for (T element : elements) {
            if (element == null) {
                throw new IllegalArgumentException("Illegal " + fieldName + " list. Null elements are not allowed. Got " + elements);
            }
            if (!(element instanceof String) || !element.toString().trim().isEmpty()) continue;
            throw new IllegalArgumentException("Illegal " + fieldName + " list. Blank elements are not allowed. Got " + elements);
        }
    }

    public static final void notEmpty(int[] field, String fieldName) {
        Args.notNull(field, fieldName);
        if (field.length == 0) {
            throw new IllegalArgumentException(fieldName + " cannot be empty");
        }
    }

    public static final void notEmpty(char[] field, String fieldName) {
        Args.notNull(field, fieldName);
        if (field.length == 0) {
            throw new IllegalArgumentException(fieldName + " cannot be empty");
        }
    }

    public static final void notEmpty(CharSequence o, String fieldName) {
        Args.notNull(o, fieldName);
        if (o.length() == 0) {
            throw new IllegalArgumentException(fieldName + " cannot be empty");
        }
    }

    public static final void notBlank(CharSequence o, String fieldName) {
        Args.notNull(o, fieldName);
        if (((Object)o).toString().trim().isEmpty()) {
            throw new IllegalArgumentException(fieldName + " cannot be blank");
        }
    }

    public static final void noBlanks(Object[] o, String fieldName) {
        Args.notNull(o, fieldName);
        for (Object e : o) {
            if (e == null) {
                throw new IllegalArgumentException("Null value in " + fieldName + ": " + Arrays.toString(o));
            }
            if (!(e instanceof CharSequence) || !Args.isBlank(e.toString())) continue;
            throw new IllegalArgumentException("Blank value in " + fieldName + ": " + Arrays.toString(o));
        }
    }

    public static final void validFile(File file, String fieldName) {
        Args.notNull(file, fieldName);
        if (!file.exists()) {
            throw new IllegalArgumentException("Illegal " + fieldName + ": '" + file.getAbsolutePath() + "' it does not exist.");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Illegal " + fieldName + ": '" + file.getAbsolutePath() + "' it cannot be a directory.");
        }
    }

    public static final void validTransactionIsolationLevel(int transactionIsolationLevel) {
        List<Integer> levels = Arrays.asList(0, 2, 1, 4, 8);
        if (!levels.contains(transactionIsolationLevel)) {
            throw new IllegalArgumentException("Illegal transaction isolation level: " + transactionIsolationLevel + ". Accepted isolation levels are: " + levels + " (from java.sql.Connection)");
        }
    }

    public static final String guessAndValidateName(String name, File file, String fieldName) {
        if (name != null) {
            Args.notBlank(name, fieldName);
            return name;
        }
        Args.validFile(file, fieldName);
        name = file.getName();
        if (name.lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("Cannot derive " + fieldName + " from file " + file.getAbsolutePath());
        }
        return name;
    }

    public static final boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static final boolean isNotBlank(String s) {
        return !Args.isBlank(s);
    }

    public static final String replaceSystemProperties(String string) {
        int offset = 0;
        int braceOpen = 0;
        while (braceOpen >= 0 && (braceOpen = string.indexOf(123, offset)) >= 0) {
            offset = braceOpen;
            int braceClose = string.indexOf(125);
            if (braceClose <= braceOpen) continue;
            offset = braceClose;
            String property = string.substring(braceOpen + 1, braceClose);
            String value = System.getProperty(property);
            if (value == null) continue;
            String beforeProperty = string.substring(0, braceOpen);
            String afterProperty = "";
            if (braceClose < string.length()) {
                afterProperty = string.substring(braceClose + 1, string.length());
            }
            string = beforeProperty + value + afterProperty;
        }
        return string;
    }

    public static final String decode(Object value) {
        return Args.decode(null, value, null);
    }

    public static final String decode(Object value, String charsetName) {
        return Args.decode(null, value, charsetName);
    }

    public static final String decode(String parameterName, Object value, String charsetName) {
        if (value == null) {
            return null;
        }
        if (charsetName == null) {
            charsetName = "UTF-8";
        }
        String stringVal = String.valueOf(value);
        try {
            stringVal = URLDecoder.decode(stringVal, charsetName);
        }
        catch (Exception ex) {
            if (parameterName == null) {
                throw new IllegalStateException("Error decoding value: " + value, ex);
            }
            throw new IllegalStateException("Error decoding value of parameter '" + parameterName + "'. Value: " + value, ex);
        }
        return stringVal;
    }

    public static final String encode(Object parameterValue) {
        return Args.encode(null, parameterValue, null);
    }

    public static final String encode(Object parameterValue, String charsetName) {
        return Args.encode(null, parameterValue, charsetName);
    }

    public static final String encode(String parameterName, Object parameterValue, String charsetName) {
        String original;
        if (parameterValue == null) {
            return null;
        }
        if (charsetName == null) {
            charsetName = "UTF-8";
        }
        String decoded = original = String.valueOf(parameterValue);
        try {
            decoded = Args.decode(parameterName, original, charsetName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (decoded.equals(original)) {
            try {
                return URLEncoder.encode(original, charsetName);
            }
            catch (Exception ex) {
                if (parameterName == null) {
                    throw new IllegalStateException("Error encoding value: " + parameterValue, ex);
                }
                throw new IllegalStateException("Error encoding value of parameter '" + parameterName + "'. Value: " + parameterValue, ex);
            }
        }
        return original;
    }

    public static final Calendar isoDateStringToCalendar(String s) {
        if (Args.isBlank(s)) {
            return null;
        }
        GregorianCalendar out = null;
        try {
            int day;
            int month;
            int year;
            int firstDash = s.indexOf(45);
            int secondDash = s.indexOf(45, firstDash + 1);
            String yyyy = s.substring(0, firstDash);
            String mm = s.substring(firstDash + 1, secondDash);
            String dd = s.substring(secondDash + 1);
            if (yyyy.length() == 4 && mm.length() == 2 && dd.length() == 2 && ((out = new GregorianCalendar(year = Integer.parseInt(yyyy), month = Integer.parseInt(mm) - 1, day = Integer.parseInt(dd))).get(1) != year || out.get(2) != month || out.get(5) != day)) {
                out = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (out == null) {
            throw new IllegalArgumentException("Date '" + s + "' must be formatted as yyyy-MM-dd");
        }
        return out;
    }

    public static boolean equals(Collection<Object[]> c1, Collection<Object[]> c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 != null) {
            if (c2 != null) {
                if (c1.size() == c2.size()) {
                    Iterator<Object[]> i1 = c1.iterator();
                    Iterator<Object[]> i2 = c2.iterator();
                    while (i1.hasNext()) {
                        if (Arrays.equals(i1.next(), i2.next())) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return c2 == null;
    }
}

