/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.api;

import com.univocity.api.CommonFactoryProvider;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public final class Builder {
    private static ConcurrentHashMap<Class, CommonFactoryProvider> providers = new ConcurrentHashMap();
    private static ServiceLoader<CommonFactoryProvider> factoryProviderLoader = ServiceLoader.load(CommonFactoryProvider.class);

    public static final synchronized void setClassLoader(ClassLoader classLoader) {
        factoryProviderLoader = ServiceLoader.load(CommonFactoryProvider.class, classLoader);
        providers.clear();
    }

    public static final <T> T build(Class<T> builderType, Object ... args) {
        T out = null;
        CommonFactoryProvider builder = providers.get(builderType);
        if (builder == null && !providers.containsKey(builderType)) {
            if (!providers.isEmpty()) {
                for (Map.Entry entry : providers.entrySet()) {
                    try {
                        out = ((CommonFactoryProvider)entry.getValue()).build(builderType, args);
                        providers.put(builderType, (CommonFactoryProvider)entry.getValue());
                        return out;
                    }
                    catch (Throwable t) {
                    }
                }
            }
            for (CommonFactoryProvider commonFactoryProvider : factoryProviderLoader) {
                try {
                    out = commonFactoryProvider.build(builderType, args);
                    providers.put(builderType, commonFactoryProvider);
                    return out;
                }
                catch (Throwable t) {
                }
            }
            if (builderType != null) {
                providers.put(builderType, new CommonFactoryProvider(){

                    @Override
                    public <T> T build(Class<T> builderType, Object ... args) {
                        return null;
                    }
                });
            }
        } else if (builder != null) {
            out = builder.build(builderType, args);
        }
        if (out == null) {
            throw new IllegalStateException("Unable to load implementation of " + builderType.getName() + ".");
        }
        return out;
    }
}

