/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.adplayer;

import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import androidx.annotation.RequiresApi;
import androidx.webkit.WebResourceErrorCompat;
import androidx.webkit.WebViewAssetLoader;
import androidx.webkit.WebViewClientCompat;
import androidx.webkit.WebViewFeature;
import com.unity3d.ads.adplayer.GetAdAssetLoader;
import com.unity3d.ads.adplayer.GetWebViewCacheAssetLoader;
import com.unity3d.ads.adplayer.model.ErrorReason;
import com.unity3d.ads.adplayer.model.WebViewClientError;
import com.unity3d.ads.core.extensions.IntExtensionKt;
import com.unity3d.ads.core.extensions.ViewExtensionsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0017J \u0010$\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0016J\u001a\u0010*\u001a\u0004\u0018\u00010&2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/unity3d/ads/adplayer/AndroidWebViewClient;", "Landroidx/webkit/WebViewClientCompat;", "getWebViewAssetLoader", "Lcom/unity3d/ads/adplayer/GetWebViewCacheAssetLoader;", "getAdAssetLoader", "Lcom/unity3d/ads/adplayer/GetAdAssetLoader;", "(Lcom/unity3d/ads/adplayer/GetWebViewCacheAssetLoader;Lcom/unity3d/ads/adplayer/GetAdAssetLoader;)V", "_isRenderProcessGone", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "_onLoadFinished", "Lkotlinx/coroutines/CompletableDeferred;", "", "Lcom/unity3d/ads/adplayer/model/WebViewClientError;", "adAssetLoader", "Landroidx/webkit/WebViewAssetLoader;", "isRenderProcessGone", "Lkotlinx/coroutines/flow/StateFlow;", "()Lkotlinx/coroutines/flow/StateFlow;", "loadErrors", "onLoadFinished", "Lkotlinx/coroutines/Deferred;", "getOnLoadFinished", "()Lkotlinx/coroutines/Deferred;", "webViewAssetLoader", "onPageFinished", "", "view", "Landroid/webkit/WebView;", "url", "", "onReceivedError", "request", "Landroid/webkit/WebResourceRequest;", "error", "Landroidx/webkit/WebResourceErrorCompat;", "onReceivedHttpError", "errorResponse", "Landroid/webkit/WebResourceResponse;", "onRenderProcessGone", "detail", "Landroid/webkit/RenderProcessGoneDetail;", "shouldInterceptRequest", "Companion", "unity-ads_release"})
public final class AndroidWebViewClient
extends WebViewClientCompat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebViewAssetLoader webViewAssetLoader;
    @NotNull
    private final WebViewAssetLoader adAssetLoader;
    @NotNull
    private final MutableStateFlow<List<WebViewClientError>> loadErrors;
    @NotNull
    private final CompletableDeferred<List<WebViewClientError>> _onLoadFinished;
    @NotNull
    private final Deferred<List<WebViewClientError>> onLoadFinished;
    @NotNull
    private final MutableStateFlow<Boolean> _isRenderProcessGone;
    @NotNull
    private final StateFlow<Boolean> isRenderProcessGone;
    @NotNull
    public static final String BLANK_PAGE = "about:blank";

    public AndroidWebViewClient(@NotNull GetWebViewCacheAssetLoader getWebViewAssetLoader, @NotNull GetAdAssetLoader getAdAssetLoader) {
        Intrinsics.checkNotNullParameter((Object)getWebViewAssetLoader, (String)"getWebViewAssetLoader");
        Intrinsics.checkNotNullParameter((Object)getAdAssetLoader, (String)"getAdAssetLoader");
        this.webViewAssetLoader = (WebViewAssetLoader)getWebViewAssetLoader.invoke();
        this.adAssetLoader = (WebViewAssetLoader)getAdAssetLoader.invoke();
        this.loadErrors = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this._onLoadFinished = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.onLoadFinished = (Deferred)this._onLoadFinished;
        this._isRenderProcessGone = StateFlowKt.MutableStateFlow((Object)false);
        this.isRenderProcessGone = FlowKt.asStateFlow(this._isRenderProcessGone);
    }

    @NotNull
    public final Deferred<List<WebViewClientError>> getOnLoadFinished() {
        return this.onLoadFinished;
    }

    @NotNull
    public final StateFlow<Boolean> isRenderProcessGone() {
        return this.isRenderProcessGone;
    }

    public void onPageFinished(@NotNull WebView view, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (Intrinsics.areEqual((Object)url, (Object)BLANK_PAGE)) {
            MutableStateFlow<List<WebViewClientError>> mutableStateFlow = this.loadErrors;
            mutableStateFlow.setValue((Object)CollectionsKt.plus((Collection)((Collection)mutableStateFlow.getValue()), (Object)new WebViewClientError(url, ErrorReason.REASON_WEB_BLANK, null, 4, null)));
        }
        super.onPageFinished(view, url);
        this._onLoadFinished.complete(this.loadErrors.getValue());
    }

    @RequiresApi(value=21)
    public void onReceivedError(@NotNull WebView view, @NotNull WebResourceRequest request2, @NotNull WebResourceErrorCompat error2) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        super.onReceivedError(view, request2, error2);
        ErrorReason reason = WebViewFeature.isFeatureSupported((String)"WEB_RESOURCE_ERROR_GET_CODE") ? IntExtensionKt.webResourceToErrorReason(error2.getErrorCode()) : ErrorReason.REASON_UNKNOWN;
        MutableStateFlow<List<WebViewClientError>> mutableStateFlow = this.loadErrors;
        mutableStateFlow.setValue((Object)CollectionsKt.plus((Collection)((Collection)mutableStateFlow.getValue()), (Object)new WebViewClientError(request2.getUrl().toString(), reason, null, 4, null)));
    }

    public void onReceivedHttpError(@NotNull WebView view, @NotNull WebResourceRequest request2, @NotNull WebResourceResponse errorResponse) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)errorResponse, (String)"errorResponse");
        super.onReceivedHttpError(view, request2, errorResponse);
        WebViewClientError error2 = Build.VERSION.SDK_INT >= 21 ? new WebViewClientError(request2.getUrl().toString(), ErrorReason.REASON_WEB_ERROR_RECEIVED_HTTP, errorResponse.getStatusCode()) : new WebViewClientError(null, ErrorReason.REASON_WEB_ERROR_RECEIVED_HTTP, null, 5, null);
        MutableStateFlow<List<WebViewClientError>> mutableStateFlow = this.loadErrors;
        mutableStateFlow.setValue((Object)CollectionsKt.plus((Collection)((Collection)mutableStateFlow.getValue()), (Object)error2));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public WebResourceResponse shouldInterceptRequest(@NotNull WebView view, @NotNull WebResourceRequest request2) {
        WebResourceResponse webResourceResponse;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        if (Build.VERSION.SDK_INT < 21) return super.shouldInterceptRequest(view, request2);
        Uri uri = request2.getUrl();
        if (uri == null) {
            return super.shouldInterceptRequest(view, request2);
        }
        Uri url = uri;
        if (Intrinsics.areEqual((Object)url.getLastPathSegment(), (Object)"favicon.ico")) {
            return new WebResourceResponse("image/png", null, null);
        }
        String string = url.getHost();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 380656434: {
                    if (!string.equals("config.unityads.unity3d.com")) break;
                    n = 1;
                    break;
                }
                case -598289184: {
                    if (!string.equals("cdn-creatives-cf-prd.acquire.unity3dusercontent.com")) break;
                    n = 2;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    webResourceResponse = this.webViewAssetLoader.shouldInterceptRequest(url);
                    return webResourceResponse;
                }
                case 2: {
                    webResourceResponse = this.adAssetLoader.shouldInterceptRequest(url);
                    return webResourceResponse;
                }
            }
        }
        webResourceResponse = super.shouldInterceptRequest(view, request2);
        return webResourceResponse;
    }

    public boolean onRenderProcessGone(@NotNull WebView view, @NotNull RenderProcessGoneDetail detail) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
        ViewExtensionsKt.removeViewFromParent((View)view);
        view.destroy();
        if (!this._onLoadFinished.isCompleted()) {
            MutableStateFlow<List<WebViewClientError>> mutableStateFlow = this.loadErrors;
            mutableStateFlow.setValue((Object)CollectionsKt.plus((Collection)((Collection)mutableStateFlow.getValue()), (Object)new WebViewClientError(String.valueOf(view.getUrl()), ErrorReason.REASON_WEBVIEW_RENDER_PROCESS_GONE, null, 4, null)));
            this._onLoadFinished.complete(this.loadErrors.getValue());
        } else {
            this._isRenderProcessGone.setValue((Object)true);
        }
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/unity3d/ads/adplayer/AndroidWebViewClient$Companion;", "", "()V", "BLANK_PAGE", "", "unity-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

