package com.unity3d.ads.core.domain

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.datasource.WebviewConfigurationDataSource
import com.unity3d.ads.core.data.repository.CampaignRepository
import gateway.v1.UniversalRequestKt.payload
import gateway.v1.UniversalRequestOuterClass.UniversalRequest
import gateway.v1.adRequest
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.SessionRepository

internal class GetAndroidAdRequest(
    private val getUniversalRequestForPayLoad: GetUniversalRequestForPayLoad,
    private val sessionRepository: SessionRepository,
    private val deviceInfoRepository: DeviceInfoRepository,
    private val campaignRepository: CampaignRepository,
    private val webViewConfigurationDataSource: WebviewConfigurationDataSource
) : GetAdRequest {
    override suspend fun invoke(placement: String, impressionOpportunity: ByteString): UniversalRequest {
        val request = adRequest {
            sessionCounters = sessionRepository.sessionCounters
            staticDeviceInfo = deviceInfoRepository.staticDeviceInfo()
            dynamicDeviceInfo = deviceInfoRepository.dynamicDeviceInfo
            impressionOpportunityId = impressionOpportunity
            placementId = placement
            requestImpressionConfiguration = true
            campaignState = campaignRepository.getCampaignState()

            // scarSignal
            webviewVersion = webViewConfigurationDataSource.get().version
        }
        val payload = payload {
            adRequest = request
        }
        return getUniversalRequestForPayLoad(payload)
    }


}