/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader;

import android.content.Context;
import android.webkit.WebSettings;
import com.unity3d.services.core.configuration.InitRequestType;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.device.reader.IDeviceInfoReader;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.SdkProperties;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class DeviceInfoReaderExtended
implements IDeviceInfoReader {
    private final IDeviceInfoReader _deviceInfoReader;

    public DeviceInfoReaderExtended(IDeviceInfoReader deviceInfoReader) {
        this._deviceInfoReader = deviceInfoReader;
    }

    @Override
    public Map<String, Object> getDeviceInfoData() {
        Map<String, Object> deviceInfoData = this._deviceInfoReader.getDeviceInfoData();
        deviceInfoData.put("bundleId", ClientProperties.getAppName());
        deviceInfoData.put("encrypted", ClientProperties.isAppDebuggable());
        deviceInfoData.put("rooted", Device.isRooted());
        deviceInfoData.put("osVersion", Device.getOsVersion());
        deviceInfoData.put("deviceModel", Device.getModel());
        deviceInfoData.put("language", Locale.getDefault().toString());
        deviceInfoData.put("connectionType", Device.getConnectionType());
        deviceInfoData.put("screenHeight", Device.getScreenHeight());
        deviceInfoData.put("screenWidth", Device.getScreenWidth());
        deviceInfoData.put("deviceMake", Device.getManufacturer());
        deviceInfoData.put("screenDensity", Device.getScreenDensity());
        deviceInfoData.put("screenSize", Device.getScreenLayout());
        deviceInfoData.put("limitAdTracking", Device.isLimitAdTrackingEnabled());
        deviceInfoData.put("networkOperator", Device.getNetworkOperator());
        deviceInfoData.put("volume", Device.getStreamVolume(1));
        deviceInfoData.put("deviceFreeSpace", Device.getFreeSpace(ClientProperties.getApplicationContext().getCacheDir()));
        deviceInfoData.put("apiLevel", String.valueOf(Device.getApiLevel()));
        deviceInfoData.put("networkType", Device.getNetworkType());
        deviceInfoData.put("bundleVersion", ClientProperties.getAppVersion());
        try {
            deviceInfoData.put("timeZone", TimeZone.getDefault().getDisplayName(false, 0, Locale.US));
        }
        catch (AssertionError assertionError) {
            DeviceLog.error("Could not read timeZone information: %s", ((Throwable)((Object)assertionError)).getMessage());
        }
        deviceInfoData.put("timeZoneOffset", TimeZone.getDefault().getOffset(System.currentTimeMillis()) / 1000);
        deviceInfoData.put("webviewUa", WebSettings.getDefaultUserAgent((Context)ClientProperties.getApplicationContext()));
        deviceInfoData.put("networkOperatorName", Device.getNetworkOperatorName());
        deviceInfoData.put("wiredHeadset", Device.isWiredHeadsetOn());
        deviceInfoData.put("versionCode", SdkProperties.getVersionCode());
        deviceInfoData.put("stores", "google");
        deviceInfoData.put("appStartTime", SdkProperties.getInitializationTimeEpoch() / 1000L);
        deviceInfoData.put("sdkVersionName", SdkProperties.getVersionName());
        deviceInfoData.put("eventTimeStamp", System.currentTimeMillis() / 1000L);
        deviceInfoData.put("cpuCount", Device.getCPUCount());
        deviceInfoData.put("usbConnected", Device.isUSBConnected());
        deviceInfoData.put("apkDeveloperSigningCertificateHash", Device.getCertificateFingerprint());
        deviceInfoData.put("deviceUpTime", Device.getUptime());
        deviceInfoData.put("deviceElapsedRealtime", Device.getElapsedRealtime());
        deviceInfoData.put("adbEnabled", Device.isAdbEnabled());
        deviceInfoData.put("androidFingerprint", Device.getFingerprint());
        deviceInfoData.put("batteryStatus", Device.getBatteryStatus());
        deviceInfoData.put("batteryLevel", Float.valueOf(Device.getBatteryLevel()));
        deviceInfoData.put("networkMetered", Device.getNetworkMetered());
        deviceInfoData.put("test", SdkProperties.isTestMode());
        deviceInfoData.put("callType", InitRequestType.TOKEN.getCallType());
        return deviceInfoData;
    }
}

