package com.unity3d.ads.core.extensions

import com.unity3d.ads.UnityAds
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_ALREADY_SHOWING
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_INIT_FAILED
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_INTERNAL
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_INVALID
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_NOT_READY
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_NO_CONNECTION
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_TIMEOUT
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_UNKNOWN
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_VIDEO_PLAYER

fun UnityAds.UnityAdsShowError.toDiagnosticReason(): String {
    return when (this) {
        UnityAds.UnityAdsShowError.NOT_INITIALIZED -> REASON_INIT_FAILED
        UnityAds.UnityAdsShowError.NOT_READY -> REASON_NOT_READY
        UnityAds.UnityAdsShowError.VIDEO_PLAYER_ERROR -> REASON_VIDEO_PLAYER
        UnityAds.UnityAdsShowError.INVALID_ARGUMENT -> REASON_INVALID
        UnityAds.UnityAdsShowError.NO_CONNECTION -> REASON_NO_CONNECTION
        UnityAds.UnityAdsShowError.ALREADY_SHOWING -> REASON_ALREADY_SHOWING
        UnityAds.UnityAdsShowError.INTERNAL_ERROR -> REASON_INTERNAL
        UnityAds.UnityAdsShowError.TIMEOUT -> REASON_TIMEOUT
        else -> REASON_UNKNOWN
    }
}