package com.unity3d.ads.core.domain.work

import android.content.Context
import androidx.work.WorkerParameters
import com.unity3d.ads.core.domain.GetRequestPolicy
import com.unity3d.services.core.di.IServiceComponent
import com.unity3d.services.core.di.ServiceProvider
import com.unity3d.services.core.di.inject

class DiagnosticEventJob(
    context: Context,
    workerParams: WorkerParameters
) : UniversalRequestJob(context, workerParams), IServiceComponent {

    private val getDiagnosticRequestPolicy: GetRequestPolicy by inject(ServiceProvider.NAMED_OTHER_REQ)

    override suspend fun doWork(): Result {
        requestPolicy = getDiagnosticRequestPolicy()
        return super.doWork()
    }
}