package com.unity3d.ads.core.domain

import com.unity3d.ads.adplayer.WebViewClientError
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.withContext

class AndroidSendWebViewClientErrorDiagnostics (
    private val ioDispatcher: CoroutineDispatcher,
    private val sendDiagnosticEvent: SendDiagnosticEvent
): SendWebViewClientErrorDiagnostics {
    override suspend fun invoke(errors: List<WebViewClientError>) = withContext(ioDispatcher) {
        errors.forEach {
            val tags = if (!it.url.isNullOrEmpty()) {
                mapOf(
                    SendDiagnosticEvent.WEBVIEW_URL to it.url,
                )
            } else {
                null
            }
            val intTags = mutableMapOf(
                SendDiagnosticEvent.REASON to it.reason.code,
            )
            if (it.statusCode != null) intTags[SendDiagnosticEvent.WEBVIEW_ERROR_CODE] = it.statusCode

            sendDiagnosticEvent(SendDiagnosticEvent.WEBVIEW_ERROR, tags = tags, intTags = intTags)
        }
    }
}