package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.DiagnosticEventRepository
import com.unity3d.ads.core.domain.events.GetDiagnosticEventRequest

import java.util.concurrent.TimeUnit

internal class AndroidSendDiagnosticEvent(
    private val diagnosticEventRepository: DiagnosticEventRepository,
    private val getDiagnosticEventRequest: GetDiagnosticEventRequest,
) : SendDiagnosticEvent {
    override suspend operator fun invoke(
        event: String,
        value: Long?,
        tags: Map<String, String>?,
        intTags: Map<String, Int>?
    ) {
        val duration = value?.let { TimeUnit.NANOSECONDS.toMillis(it).toDouble() }
        val diagnosticEventRequest = getDiagnosticEventRequest(event, tags, intTags, duration)
        diagnosticEventRepository.addDiagnosticEvent(diagnosticEventRequest)
    }
}