package com.unity3d.ads.adplayer

import android.graphics.Color
import android.view.ViewGroup
import android.widget.RelativeLayout
import androidx.core.view.doOnAttach
import androidx.core.view.doOnDetach
import androidx.core.view.updateLayoutParams
import com.unity3d.services.banners.UnityBannerSize
import com.unity3d.services.core.misc.ViewUtilities
import kotlinx.coroutines.*

internal class AndroidEmbeddableWebViewAdPlayer(
    private val webViewAdPlayer: WebViewAdPlayer,
    private val webViewContainer: AndroidWebViewContainer,
) : AdPlayer by webViewAdPlayer, EmbeddableAdPlayer {
    override suspend fun getEmbeddable(showOptions: ShowOptions, size: UnityBannerSize): ViewGroup = coroutineScope {
        require(showOptions is AndroidShowOptions)
        val context = showOptions.context

        val bannerContainer = RelativeLayout(context).apply {
            setBackgroundColor(Color.TRANSPARENT)
            gravity = android.view.Gravity.CENTER
            updateLayoutParams<RelativeLayout.LayoutParams> {
                // todo: move viewUtilities to the package
                // Although the size received is in pixels, this conversion is necessary to avoid the webview from being too small.
                // Webview respects the viewport meta tag, so it will not be bigger than the screen.
                // We can experiment with sizes later
                width = ViewUtilities.dpFromPx(context, size.width.toFloat()).toInt()
                height = ViewUtilities.dpFromPx(context, size.height.toFloat()).toInt()
            }
            addView(webViewContainer.webView)
            doOnAttach {
                this@coroutineScope.launch { webViewAdPlayer.requestShow() }
            }
            doOnDetach {
                removeAllViews()
                this@coroutineScope.launch { webViewContainer.destroy() }
            }
        }

        bannerContainer
    }
}