package com.unity3d.ads

import android.app.Activity
import android.content.Context
import com.unity3d.services.ads.UnityAdsImplementation

object UnityAds {
    /**
     * Initializes Unity Ads. Unity Ads should be initialized when app starts.
     *
     * @param context Current Android context of calling app in favor of Application Context
     * @param gameId Unique identifier for a game, given by Unity Ads admin tools or Unity editor
     */
    @JvmStatic
    fun initialize(context: Context?, gameId: String?) {
        val testMode = false
        UnityAdsImplementation.getInstance().initialize(context, gameId, testMode, null)
    }

    /**
     * Initializes Unity Ads. Unity Ads should be initialized when app starts.
     *
     * @param context Current Android context of calling app in favor of Application Context
     * @param gameId Unique identifier for a game, given by Unity Ads admin tools or Unity editor
     * @param initializationListener Listener for IUnityAdsInitializationListener callbacks
     */
    @JvmStatic
    fun initialize(context: Context?, gameId: String?, initializationListener: IUnityAdsInitializationListener?) {
        val testMode = false
        UnityAdsImplementation.getInstance().initialize(context, gameId, testMode, initializationListener)
    }

    /**
     * Initializes Unity Ads. Unity Ads should be initialized when app starts.
     *
     * @param context Current Android context of calling app in favor of Application Context
     * @param gameId Unique identifier for a game, given by Unity Ads admin tools or Unity editor
     * @param testMode If true, only test ads are shown
     */
    @JvmStatic
    fun initialize(context: Context?, gameId: String?, testMode: Boolean) {
        UnityAdsImplementation.getInstance().initialize(context, gameId, testMode, null)
    }

    /**
     * Initializes Unity Ads. Unity Ads should be initialized when app starts.
     *
     * @param context Current Android context of calling app in favor of Application Context
     * @param gameId Unique identifier for a game, given by Unity Ads admin tools or Unity editor
     * @param testMode If true, only test ads are shown
     * @param initializationListener Listener for IUnityAdsInitializationListener callbacks
     */
    @JvmStatic
    fun initialize(
        context: Context?,
        gameId: String?,
        testMode: Boolean,
        initializationListener: IUnityAdsInitializationListener?
    ) {
        UnityAdsImplementation.getInstance().initialize(context, gameId, testMode, initializationListener)
    }

    @JvmStatic
    val isInitialized: Boolean
        /**
         * Checks if Unity Ads has been initialized. This might be useful for debugging initialization problems.
         *
         * @return If true, Unity Ads has been successfully initialized
         */
        get() = UnityAdsImplementation.getInstance().isInitialized
    @JvmStatic
    val isSupported: Boolean
        /**
         * Checks if current device supports running Unity Ads
         *
         * @return If true, device supports Unity Ads. If false, device can't initialize or show Unity Ads.
         */
        get() = UnityAdsImplementation.getInstance().isSupported
    @JvmStatic
    val version: String
        /**
         * Get current SDK version
         *
         * @return Current SDK version name
         */
        get() = UnityAdsImplementation.getInstance().version

    /**
     * Show one advertisement with custom placement.
     *
     * @param activity Current Android activity of calling app
     * @param placementId Placement, as defined in Unity Ads admin tools
     */
    @Deprecated("")
    @JvmStatic
    fun show(activity: Activity?, placementId: String?) {
        UnityAdsImplementation.getInstance().show(activity, placementId, UnityAdsShowOptions(), null)
    }

    /**
     * Show one advertisement with custom placement and custom options.
     *
     * @param activity Current Android activity of calling app
     * @param placementId Placement, as defined in Unity Ads admin tools
     * @param showListener Listener for IUnityAdsShowListener callbacks
     */
    @JvmStatic
    fun show(activity: Activity?, placementId: String?, showListener: IUnityAdsShowListener?) {
        UnityAdsImplementation.getInstance().show(activity, placementId, UnityAdsShowOptions(), showListener)
    }

    /**
     * Show one advertisement with custom placement and custom options.
     *
     * @param activity Current Android activity of calling app
     * @param placementId Placement, as defined in Unity Ads admin tools
     * @param options Custom options
     */
    @Deprecated("")
    @JvmStatic
    fun show(activity: Activity?, placementId: String?, options: UnityAdsShowOptions?) {
        UnityAdsImplementation.getInstance().show(activity, placementId, options, null)
    }

    /**
     * Show one advertisement with custom placement and custom options.
     *
     * @param activity Current Android activity of calling app
     * @param placementId Placement, as defined in Unity Ads admin tools
     * @param options Custom options
     * @param showListener Listener for IUnityAdsShowListener callbacks
     */
    @JvmStatic
    fun show(
        activity: Activity?,
        placementId: String?,
        options: UnityAdsShowOptions?,
        showListener: IUnityAdsShowListener?
    ) {
        UnityAdsImplementation.getInstance().show(activity, placementId, options, showListener)
    }

    @JvmStatic
    var debugMode: Boolean
        /**
         * Get current debug mode status
         *
         * @return If true, debug mode is on. If false, debug mode is off.
         */
        get() = UnityAdsImplementation.getInstance().debugMode
        /**
         * Toggles debug mode on/off
         *
         * @param debugMode If true, debug mode is on and there will be lots of debug output from Unity Ads. If false, there will be only some short log messages from Unity Ads.
         */
        set(debugMode) {
            UnityAdsImplementation.getInstance().debugMode = debugMode
        }

    /**
     * Request fill for a specific placement ID.
     *
     * @param placementId The placement ID to be loaded.
     */
    @Deprecated("")
    @JvmStatic
    fun load(placementId: String?) {
        load(placementId, object : IUnityAdsLoadListener {
            override fun onUnityAdsAdLoaded(placementId: String) {}
            override fun onUnityAdsFailedToLoad(placementId: String, error: UnityAdsLoadError, message: String) {}
        })
    }

    /**
     * Request fill for a specific placement ID.
     *
     * @param placementId The placement ID to be loaded.
     * @param listener The listener which is going to be notified about load request result.
     */
    @JvmStatic
    fun load(placementId: String?, listener: IUnityAdsLoadListener?) {
        UnityAdsImplementation.getInstance().load(placementId, UnityAdsLoadOptions(), listener)
    }

    /**
     * Request fill for a specific placement ID with custom options.
     *
     * @param placementId The placement ID to be loaded.
     * @param loadOptions Custom options.
     * @param listener The listener which is going to be notified about load request result.
     */
    @JvmStatic
    fun load(placementId: String?, loadOptions: UnityAdsLoadOptions?, listener: IUnityAdsLoadListener?) {
        UnityAdsImplementation.getInstance().load(placementId, loadOptions, listener)
    }
    @JvmStatic
    val token: String?
        /**
         * Get request token.
         */
        get() = UnityAdsImplementation.getInstance().token

    /**
     * Get request token in asynchronous way.
     */
    @JvmStatic
    fun getToken(listener: IUnityAdsTokenListener?) {
        UnityAdsImplementation.getInstance().getToken(listener)
    }

    enum class UnityAdsShowCompletionState {
        /**
         * A state that indicates that the user skipped the ad.
         */
        SKIPPED,

        /**
         * A state that indicates that the ad was played entirely.
         */
        COMPLETED
    }

    /**
     * Enumeration of UnityAds initialization errors.
     */
    enum class UnityAdsInitializationError {
        /**
         * Error related to environment or internal services
         */
        INTERNAL_ERROR,

        /**
         * Error related to invalid arguments
         */
        INVALID_ARGUMENT,

        /**
         * Error related to url being blocked
         */
        AD_BLOCKER_DETECTED
    }

    /**
     * Enumeration of UnityAds load errors.
     */
    enum class UnityAdsLoadError {
        /**
         * Error related to SDK not initialized
         */
        INITIALIZE_FAILED,

        /**
         * Error related to environment or internal services
         */
        INTERNAL_ERROR,

        /**
         * Error related to invalid arguments
         */
        INVALID_ARGUMENT,

        /**
         * Error related to there being no ads available
         */
        NO_FILL,

        /**
         * Error related to an Ad being unable to load within a specified time frame
         */
        TIMEOUT
    }

    /**
     * Enumeration of UnityAds show errors.
     */
    enum class UnityAdsShowError {
        /**
         * Error related to SDK not initialized
         */
        NOT_INITIALIZED,

        /**
         * Error related to placement not being ready
         */
        NOT_READY,

        /**
         * Error related to the video player
         */
        VIDEO_PLAYER_ERROR,

        /**
         * Error related to invalid arguments
         */
        INVALID_ARGUMENT,

        /**
         * Error related to internet connection
         */
        NO_CONNECTION,

        /**
         * Error related to ad is already being showed
         */
        ALREADY_SHOWING,

        /**
         * Error related to environment or internal services
         */
        INTERNAL_ERROR,

        /**
         * Error related to an Ad being unable to show within a specified time frame
         */
        TIMEOUT
    }
}
