/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.banners.view;

import android.view.ViewGroup;
import android.widget.RelativeLayout;

public enum BannerPosition {
    TOP_LEFT(new int[]{10, 9}, 51),
    TOP_CENTER(new int[]{10, 14}, 49),
    TOP_RIGHT(new int[]{10, 11}, 53),
    BOTTOM_LEFT(new int[]{12, 9}, 83),
    BOTTOM_CENTER(new int[]{12, 14}, 81),
    BOTTOM_RIGHT(new int[]{12, 11}, 85),
    CENTER(new int[]{13}, 17),
    NONE(new int[0], 0);

    private final int[] _rules;
    private int _gravity;

    private BannerPosition(int[] rules, int gravity) {
        this._rules = rules;
        this._gravity = gravity;
    }

    public static BannerPosition fromString(String in) {
        if (in == null || in.equals("none")) {
            return NONE;
        }
        if (in.equals("topleft")) {
            return TOP_LEFT;
        }
        if (in.equals("topright")) {
            return TOP_RIGHT;
        }
        if (in.equals("topcenter")) {
            return TOP_CENTER;
        }
        if (in.equals("bottomleft")) {
            return BOTTOM_LEFT;
        }
        if (in.equals("bottomright")) {
            return BOTTOM_RIGHT;
        }
        if (in.equals("bottomcenter")) {
            return BOTTOM_CENTER;
        }
        if (in.equals("center")) {
            return CENTER;
        }
        return NONE;
    }

    public ViewGroup.LayoutParams addLayoutRules(RelativeLayout.LayoutParams params) {
        for (int rule : this._rules) {
            params.addRule(rule);
        }
        return params;
    }

    public int getGravity() {
        return this._gravity;
    }
}

