/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.request;

import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.request.IWebRequestProgressListener;
import com.unity3d.services.core.request.NetworkIOException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class WebRequest {
    private URL _url;
    private String _requestType;
    private byte[] _body;
    private Map<String, List<String>> _headers;
    private Map<String, List<String>> _responseHeaders;
    private int _responseCode = -1;
    private long _contentLength = -1L;
    private boolean _canceled = false;
    private ByteArrayOutputStream _baos;
    private int _connectTimeout;
    private int _readTimeout;
    private IWebRequestProgressListener _progressListener;

    public WebRequest(String url, String requestType) throws MalformedURLException {
        this(url, requestType, null);
    }

    public WebRequest(String url, String requestType, Map<String, List<String>> headers) throws MalformedURLException {
        this(url, requestType, headers, 30000, 30000);
    }

    public WebRequest(String url, String requestType, Map<String, List<String>> headers, int connectTimeout, int readTimeout) throws MalformedURLException {
        this._url = new URL(url);
        this._requestType = requestType;
        this._headers = headers;
        this._connectTimeout = connectTimeout;
        this._readTimeout = readTimeout;
    }

    public void cancel() {
        this._canceled = true;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public URL getUrl() {
        return this._url;
    }

    public String getRequestType() {
        return this._requestType;
    }

    public byte[] getBody() {
        return this._body;
    }

    public void setBody(String body) {
        this._body = body.getBytes(StandardCharsets.UTF_8);
    }

    public void setBody(byte[] body) {
        this._body = body;
    }

    public String getQuery() {
        if (this._url != null) {
            return this._url.getQuery();
        }
        return null;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this._responseHeaders;
    }

    public Map<String, List<String>> getHeaders() {
        return this._headers;
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(int timeout) {
        this._connectTimeout = timeout;
    }

    public int getReadTimeout() {
        return this._readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this._readTimeout = readTimeout;
    }

    public void setProgressListener(IWebRequestProgressListener listener2) {
        this._progressListener = listener2;
    }

    public long makeStreamRequest(OutputStream outputStream) throws Exception {
        InputStream input;
        HttpURLConnection connection;
        block27: {
            connection = this.getHttpUrlConnectionWithHeaders();
            connection.setDoInput(true);
            if (this.getRequestType().equals(RequestType.POST.name())) {
                connection.setDoOutput(true);
                OutputStream pout = null;
                try {
                    pout = connection.getOutputStream();
                    if (this.getBody() == null) {
                        String query = this.getQuery();
                        if (query != null) {
                            pout.write(query.getBytes(StandardCharsets.UTF_8));
                        }
                    } else {
                        pout.write(this.getBody());
                    }
                    pout.flush();
                }
                catch (IOException e) {
                    DeviceLog.exception("Error while writing POST params", e);
                    throw new NetworkIOException("Error writing POST params: " + e.getMessage());
                }
                finally {
                    try {
                        if (pout != null) {
                            pout.close();
                        }
                    }
                    catch (IOException e) {
                        DeviceLog.exception("Error closing writer", e);
                    }
                }
            }
            try {
                this._responseCode = connection.getResponseCode();
            }
            catch (IOException | RuntimeException e) {
                throw new NetworkIOException("Response code: " + e.getMessage());
            }
            this._contentLength = connection.getContentLength();
            if (this._contentLength == -1L) {
                this._contentLength = connection.getHeaderFieldInt("X-OrigLength", -1);
            }
            if (this._baos != null && this._baos == outputStream && this._contentLength > 0L) {
                this._baos = new ByteArrayOutputStream((int)this._contentLength);
                outputStream = this._baos;
            }
            if (connection.getHeaderFields() != null) {
                this._responseHeaders = connection.getHeaderFields();
            }
            try {
                input = connection.getInputStream();
            }
            catch (IOException e) {
                input = connection.getErrorStream();
                if (input != null) break block27;
                throw new NetworkIOException("Can't open error stream: " + e.getMessage());
            }
        }
        if (this._progressListener != null) {
            this._progressListener.onRequestStart(this.getUrl().toString(), this._contentLength, this._responseCode, this._responseHeaders);
        }
        BufferedInputStream binput = new BufferedInputStream(input);
        int bytesRead = 0;
        long total = 0L;
        byte[] readTarget = new byte[4096];
        while (!this.isCanceled() && bytesRead != -1) {
            try {
                bytesRead = binput.read(readTarget);
            }
            catch (IOException e) {
                throw new NetworkIOException("Network exception: " + e.getMessage());
            }
            catch (Exception e) {
                throw new Exception("Unknown Exception: " + e.getMessage());
            }
            if (bytesRead <= 0) continue;
            outputStream.write(readTarget, 0, bytesRead);
            total += (long)bytesRead;
            if (this._progressListener == null) continue;
            this._progressListener.onRequestProgress(this.getUrl().toString(), total, this._contentLength);
        }
        connection.disconnect();
        outputStream.flush();
        return total;
    }

    public String makeRequest() throws Exception {
        this._baos = new ByteArrayOutputStream();
        this.makeStreamRequest(this._baos);
        return this._baos.toString("UTF-8");
    }

    private HttpURLConnection getHttpUrlConnectionWithHeaders() throws NetworkIOException, IllegalArgumentException {
        HttpURLConnection connection;
        if (this.getUrl().toString().startsWith("https://")) {
            try {
                connection = (HttpsURLConnection)this.getUrl().openConnection();
            }
            catch (IOException e) {
                throw new NetworkIOException("Open HTTPS connection: " + e.getMessage());
            }
        } else if (this.getUrl().toString().startsWith("http://")) {
            try {
                connection = (HttpURLConnection)this.getUrl().openConnection();
            }
            catch (IOException e) {
                throw new NetworkIOException("Open HTTP connection: " + e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Invalid url-protocol in url: " + this.getUrl().toString());
        }
        connection.setInstanceFollowRedirects(false);
        connection.setConnectTimeout(this.getConnectTimeout());
        connection.setReadTimeout(this.getReadTimeout());
        try {
            connection.setRequestMethod(this.getRequestType());
        }
        catch (ProtocolException e) {
            throw new NetworkIOException("Set Request Method: " + this.getRequestType() + ", " + e.getMessage());
        }
        if (this.getHeaders() != null && this.getHeaders().size() > 0) {
            for (String k : this.getHeaders().keySet()) {
                for (String value : this.getHeaders().get(k)) {
                    DeviceLog.debug("Setting header: " + k + "=" + value);
                    connection.setRequestProperty(k, value);
                }
            }
        }
        return connection;
    }

    public static enum RequestType {
        POST,
        GET,
        HEAD;

    }
}

