/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.webview.bridge;

import android.net.Uri;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import androidx.webkit.JavaScriptReplyProxy;
import androidx.webkit.WebMessageCompat;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.webview.bridge.IInvocationCallbackInvoker;
import com.unity3d.services.core.webview.bridge.IWebViewBridge;
import com.unity3d.services.core.webview.bridge.Invocation;
import com.unity3d.services.core.webview.bridge.SharedInstances;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0007J.\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J.\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001f\u0010\u001b\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00010\u00010\u001c*\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/unity3d/services/core/webview/bridge/WebViewBridgeInterface;", "", "webViewBridge", "Lcom/unity3d/services/core/webview/bridge/IWebViewBridge;", "webViewAppInvocationCallbackInvoker", "Lcom/unity3d/services/core/webview/bridge/IInvocationCallbackInvoker;", "(Lcom/unity3d/services/core/webview/bridge/IWebViewBridge;Lcom/unity3d/services/core/webview/bridge/IInvocationCallbackInvoker;)V", "handleCallback", "", "callbackId", "", "callbackStatus", "rawParameters", "handleInvocation", "data", "onHandleCallback", "view", "Landroid/webkit/WebView;", "message", "Landroidx/webkit/WebMessageCompat;", "sourceOrigin", "Landroid/net/Uri;", "isMainFrame", "", "replyProxy", "Landroidx/webkit/JavaScriptReplyProxy;", "onHandleInvocation", "toTypedArray", "", "kotlin.jvm.PlatformType", "Lorg/json/JSONArray;", "(Lorg/json/JSONArray;)[Ljava/lang/Object;", "unity-ads_release"})
@SourceDebugExtension(value={"SMAP\nWebViewBridgeInterface.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewBridgeInterface.kt\ncom/unity3d/services/core/webview/bridge/WebViewBridgeInterface\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,71:1\n1549#2:72\n1620#2,3:73\n37#3,2:76\n*S KotlinDebug\n*F\n+ 1 WebViewBridgeInterface.kt\ncom/unity3d/services/core/webview/bridge/WebViewBridgeInterface\n*L\n19#1:72\n19#1:73,3\n19#1:76,2\n*E\n"})
public final class WebViewBridgeInterface {
    @NotNull
    private final IWebViewBridge webViewBridge;
    @NotNull
    private final IInvocationCallbackInvoker webViewAppInvocationCallbackInvoker;

    public WebViewBridgeInterface(@NotNull IWebViewBridge webViewBridge2, @NotNull IInvocationCallbackInvoker webViewAppInvocationCallbackInvoker) {
        Intrinsics.checkNotNullParameter((Object)webViewBridge2, (String)"webViewBridge");
        Intrinsics.checkNotNullParameter((Object)webViewAppInvocationCallbackInvoker, (String)"webViewAppInvocationCallbackInvoker");
        this.webViewBridge = webViewBridge2;
        this.webViewAppInvocationCallbackInvoker = webViewAppInvocationCallbackInvoker;
    }

    public /* synthetic */ WebViewBridgeInterface(IWebViewBridge iWebViewBridge, IInvocationCallbackInvoker iInvocationCallbackInvoker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iWebViewBridge = SharedInstances.INSTANCE.getWebViewBridge();
        }
        if ((n & 2) != 0) {
            iInvocationCallbackInvoker = SharedInstances.INSTANCE.getWebViewAppInvocationCallbackInvoker();
        }
        this(iWebViewBridge, iInvocationCallbackInvoker);
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] toTypedArray(JSONArray $this$toTypedArray) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$this$toTypedArray.length());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p0;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add($this$toTypedArray.get((int)p0));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }

    @JavascriptInterface
    public final void handleInvocation(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DeviceLog.debug("handleInvocation " + data);
        JSONArray invocationArray = new JSONArray(data);
        Invocation batch = new Invocation(this.webViewAppInvocationCallbackInvoker, this.webViewBridge);
        int n = invocationArray.length();
        for (int idx = 0; idx < n; ++idx) {
            Object object = invocationArray.get(idx);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.JSONArray");
            JSONArray currentInvocation = (JSONArray)object;
            Object object2 = currentInvocation.get(0);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
            String className = (String)object2;
            Object object3 = currentInvocation.get(1);
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
            String methodName = (String)object3;
            Object object4 = currentInvocation.get(2);
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type org.json.JSONArray");
            JSONArray parameters = (JSONArray)object4;
            Object object5 = currentInvocation.get(3);
            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.String");
            String callback = (String)object5;
            batch.addInvocation(className, methodName, this.toTypedArray(parameters), new WebViewCallback(callback, batch.getId()));
            batch.nextInvocation();
        }
        batch.sendInvocationCallback();
    }

    @JavascriptInterface
    public final void handleCallback(@NotNull String callbackId, @NotNull String callbackStatus, @NotNull String rawParameters) {
        Intrinsics.checkNotNullParameter((Object)callbackId, (String)"callbackId");
        Intrinsics.checkNotNullParameter((Object)callbackStatus, (String)"callbackStatus");
        Intrinsics.checkNotNullParameter((Object)rawParameters, (String)"rawParameters");
        DeviceLog.debug("handleCallback " + callbackId + ' ' + callbackStatus + ' ' + rawParameters);
        JSONArray parameters = new JSONArray(rawParameters);
        this.webViewBridge.handleCallback(callbackId, callbackStatus, this.toTypedArray(parameters));
    }

    public final void onHandleInvocation(@NotNull WebView view, @NotNull WebMessageCompat message, @NotNull Uri sourceOrigin, boolean isMainFrame, @NotNull JavaScriptReplyProxy replyProxy) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)sourceOrigin, (String)"sourceOrigin");
        Intrinsics.checkNotNullParameter((Object)replyProxy, (String)"replyProxy");
        String data = message.getData();
        if (!isMainFrame || (charSequence = (CharSequence)data) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        this.handleInvocation(data);
    }

    public final void onHandleCallback(@NotNull WebView view, @NotNull WebMessageCompat message, @NotNull Uri sourceOrigin, boolean isMainFrame, @NotNull JavaScriptReplyProxy replyProxy) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)sourceOrigin, (String)"sourceOrigin");
        Intrinsics.checkNotNullParameter((Object)replyProxy, (String)"replyProxy");
        String data = message.getData();
        if (!isMainFrame || (charSequence = (CharSequence)data) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        JSONObject parameters = new JSONObject(data);
        String callbackId = parameters.getString("id");
        String callbackStatus = parameters.getString("status");
        String rawParameters = parameters.getString("parameters");
        Intrinsics.checkNotNullExpressionValue((Object)callbackId, (String)"callbackId");
        Intrinsics.checkNotNullExpressionValue((Object)callbackStatus, (String)"callbackStatus");
        Intrinsics.checkNotNullExpressionValue((Object)rawParameters, (String)"rawParameters");
        this.handleCallback(callbackId, callbackStatus, rawParameters);
    }

    public WebViewBridgeInterface() {
        this(null, null, 3, null);
    }
}

