/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device;

import com.unity3d.services.core.device.StorageEvent;
import com.unity3d.services.core.device.StorageManager;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.JsonStorage;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.io.File;
import java.io.FileNotFoundException;
import org.json.JSONObject;

public class Storage
extends JsonStorage {
    private String _targetFileName;
    private StorageManager.StorageType _type;

    public Storage(String targetFileName, StorageManager.StorageType type) {
        this._targetFileName = targetFileName;
        this._type = type;
    }

    public StorageManager.StorageType getType() {
        return this._type;
    }

    public synchronized boolean readStorage() {
        File f = new File(this._targetFileName);
        try {
            byte[] bytes = Utilities.readFileBytes(f);
            if (bytes == null) {
                return false;
            }
            String fileData = new String(bytes);
            this.setData(new JSONObject(fileData));
            return true;
        }
        catch (FileNotFoundException e) {
            DeviceLog.debug("Storage JSON file not found in local cache:", e);
            return false;
        }
        catch (Exception e) {
            DeviceLog.debug("Failed to read storage JSON file:", e);
            return false;
        }
    }

    public synchronized boolean initStorage() {
        this.readStorage();
        super.initData();
        return true;
    }

    public synchronized boolean writeStorage() {
        File f = new File(this._targetFileName);
        if (this.getData() != null) {
            boolean success2 = Utilities.writeFile(f, this.getData().toString());
            return success2;
        }
        return false;
    }

    public synchronized boolean clearStorage() {
        this.clearData();
        File f = new File(this._targetFileName);
        return f.delete();
    }

    public synchronized boolean storageFileExists() {
        File f = new File(this._targetFileName);
        return f.exists();
    }

    public synchronized void sendEvent(StorageEvent eventType, Object value) {
        boolean success2 = false;
        if (WebViewApp.getCurrentApp() != null) {
            success2 = WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORAGE, eventType, this._type.name(), value);
        }
        if (!success2) {
            DeviceLog.debug("Couldn't send storage event to WebApp");
        }
    }
}

