/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.banners.api;

import com.unity3d.ads.UnityAds;
import com.unity3d.services.ads.operation.load.ILoadOperation;
import com.unity3d.services.ads.operation.load.LoadBannerModule;
import com.unity3d.services.ads.operation.load.LoadBannerOperationState;
import com.unity3d.services.banners.UnityBannerSize;
import com.unity3d.services.banners.properties.BannerRefreshInfo;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;

public class Banner {
    @WebViewExposed
    public static void load(String bannerViewTypeString, Integer width, Integer height, String bannerAdId, WebViewCallback callback) {
        BannerViewType bannerViewType = BannerViewType.fromString(bannerViewTypeString);
        switch (bannerViewType) {
            case WEB_PLAYER: {
                ILoadOperation operationState = (ILoadOperation)LoadBannerModule.getInstance().get(bannerAdId);
                if (operationState instanceof LoadBannerOperationState) {
                    ((LoadBannerOperationState)((Object)operationState)).setSize(new UnityBannerSize(width, height));
                }
                LoadBannerModule.getInstance().onUnityAdsAdLoaded(bannerAdId);
                break;
            }
            case UNKNOWN: {
                LoadBannerModule.getInstance().onUnityAdsFailedToLoad(bannerAdId, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, "Unknown banner type");
            }
        }
        callback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void setRefreshRate(String placementId, Integer refreshRate, WebViewCallback callback) {
        if (placementId != null && refreshRate != null) {
            BannerRefreshInfo.getInstance().setRefreshRate(placementId, refreshRate);
        }
        callback.invoke(new Object[0]);
    }

    private static enum BannerViewType {
        WEB_PLAYER,
        UNKNOWN;


        public static BannerViewType fromString(String type) {
            try {
                return BannerViewType.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }
    }
}

