/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device;

import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.device.VolumeChange;
import com.unity3d.services.core.device.VolumeChangeListener;
import com.unity3d.services.core.properties.ClientProperties;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/unity3d/services/core/device/VolumeChangeContentObserver;", "Lcom/unity3d/services/core/device/VolumeChange;", "()V", "contentObserver", "Landroid/database/ContentObserver;", "listeners", "", "Lcom/unity3d/services/core/device/VolumeChangeListener;", "clearAllListeners", "", "registerListener", "volumeChangeListener", "startObserving", "stopObserving", "triggerListeners", "unregisterListener", "unity-ads_release"})
public final class VolumeChangeContentObserver
implements VolumeChange {
    @Nullable
    private ContentObserver contentObserver;
    @NotNull
    private List<VolumeChangeListener> listeners = new ArrayList();

    @Override
    public synchronized void startObserving() {
        block1: {
            if (this.contentObserver != null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            this.contentObserver = new ContentObserver(this, handler){
                final /* synthetic */ VolumeChangeContentObserver this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public boolean deliverSelfNotifications() {
                    return false;
                }

                public void onChange(boolean selfChange, @Nullable Uri uri) {
                    VolumeChangeContentObserver.access$triggerListeners(this.this$0);
                }
            };
            Context context = ClientProperties.getApplicationContext();
            Context context2 = context;
            if (context2 == null || (context2 = context2.getContentResolver()) == null) break block1;
            ContentObserver contentObserver = this.contentObserver;
            Intrinsics.checkNotNull((Object)contentObserver, (String)"null cannot be cast to non-null type android.database.ContentObserver");
            context2.registerContentObserver(Settings.System.CONTENT_URI, true, contentObserver);
        }
    }

    @Override
    public synchronized void stopObserving() {
        if (this.contentObserver == null) {
            return;
        }
        Context context = ClientProperties.getApplicationContext();
        Context context2 = context;
        if (context2 != null && (context2 = context2.getContentResolver()) != null) {
            ContentObserver contentObserver = this.contentObserver;
            Intrinsics.checkNotNull((Object)contentObserver);
            context2.unregisterContentObserver(contentObserver);
        }
        this.contentObserver = null;
    }

    @Override
    public synchronized void registerListener(@NotNull VolumeChangeListener volumeChangeListener) {
        Intrinsics.checkNotNullParameter((Object)volumeChangeListener, (String)"volumeChangeListener");
        if (!this.listeners.contains(volumeChangeListener)) {
            this.startObserving();
            this.listeners.add(volumeChangeListener);
        }
    }

    @Override
    public synchronized void unregisterListener(@NotNull VolumeChangeListener volumeChangeListener) {
        Intrinsics.checkNotNullParameter((Object)volumeChangeListener, (String)"volumeChangeListener");
        this.listeners.remove(volumeChangeListener);
        if (this.listeners.isEmpty()) {
            this.stopObserving();
        }
    }

    @Override
    public synchronized void clearAllListeners() {
        this.listeners.clear();
        this.stopObserving();
    }

    private final synchronized void triggerListeners() {
        for (VolumeChangeListener listener2 : this.listeners) {
            int currentVolume = Device.getStreamVolume(listener2.getStreamType());
            listener2.onVolumeChanged(currentVolume);
        }
    }

    public static final /* synthetic */ void access$triggerListeners(VolumeChangeContentObserver $this) {
        $this.triggerListeners();
    }
}

