/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.adunit;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.unity3d.services.ads.adunit.AdUnitEvent;
import com.unity3d.services.ads.adunit.AdUnitRelativeLayout;
import com.unity3d.services.ads.adunit.AdUnitViewHandlerFactory;
import com.unity3d.services.ads.adunit.IAdUnitViewHandler;
import com.unity3d.services.ads.adunit.IAdUnitViewHandlerFactory;
import com.unity3d.services.ads.adunit.PermissionsEvent;
import com.unity3d.services.ads.api.AdUnit;
import com.unity3d.services.core.api.Intent;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.ViewUtilities;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;

public class AdUnitActivity
extends Activity {
    public static final String EXTRA_VIEWS = "views";
    public static final String EXTRA_ACTIVITY_ID = "activityId";
    public static final String EXTRA_ORIENTATION = "orientation";
    public static final String EXTRA_SYSTEM_UI_VISIBILITY = "systemUiVisibility";
    public static final String EXTRA_KEY_EVENT_LIST = "keyEvents";
    public static final String EXTRA_KEEP_SCREEN_ON = "keepScreenOn";
    public static final String EXTRA_DISPLAY_CUTOUT_MODE = "displayCutoutMode";
    protected AdUnitRelativeLayout _layout;
    private String[] _views;
    private int _orientation = -1;
    private int _systemUiVisibility;
    private int _activityId;
    private ArrayList<Integer> _keyEventList;
    boolean _keepScreenOn;
    private Map<String, IAdUnitViewHandler> _viewHandlers;
    private int _displayCutoutMode;
    private final IAdUnitViewHandlerFactory _adUnitViewHandlerFactory = new AdUnitViewHandlerFactory();

    protected void onCreate(Bundle savedInstanceState) {
        AdUnitEvent event;
        super.onCreate(savedInstanceState);
        if (WebViewApp.getCurrentApp() == null) {
            DeviceLog.error("Unity Ads web app is null, closing Unity Ads activity from onCreate");
            this.finish();
            return;
        }
        AdUnit.setAdUnitActivity(this);
        Intent.setActiveActivity(this);
        this.createLayout();
        ViewUtilities.removeViewFromParent((View)this._layout);
        this.addContentView((View)this._layout, this._layout.getLayoutParams());
        if (savedInstanceState == null) {
            this._views = this.getIntent().getStringArrayExtra(EXTRA_VIEWS);
            this._keyEventList = this.getIntent().getIntegerArrayListExtra(EXTRA_KEY_EVENT_LIST);
            if (this.getIntent().hasExtra(EXTRA_ORIENTATION)) {
                this._orientation = this.getIntent().getIntExtra(EXTRA_ORIENTATION, -1);
            }
            if (this.getIntent().hasExtra(EXTRA_SYSTEM_UI_VISIBILITY)) {
                this._systemUiVisibility = this.getIntent().getIntExtra(EXTRA_SYSTEM_UI_VISIBILITY, 0);
            }
            if (this.getIntent().hasExtra(EXTRA_ACTIVITY_ID)) {
                this._activityId = this.getIntent().getIntExtra(EXTRA_ACTIVITY_ID, -1);
            }
            if (this.getIntent().hasExtra(EXTRA_DISPLAY_CUTOUT_MODE)) {
                this._displayCutoutMode = this.getIntent().getIntExtra(EXTRA_DISPLAY_CUTOUT_MODE, 0);
            }
            event = AdUnitEvent.ON_CREATE;
        } else {
            this._views = savedInstanceState.getStringArray(EXTRA_VIEWS);
            this._orientation = savedInstanceState.getInt(EXTRA_ORIENTATION, -1);
            this._systemUiVisibility = savedInstanceState.getInt(EXTRA_SYSTEM_UI_VISIBILITY, 0);
            this._keyEventList = savedInstanceState.getIntegerArrayList(EXTRA_KEY_EVENT_LIST);
            this._keepScreenOn = savedInstanceState.getBoolean(EXTRA_KEEP_SCREEN_ON);
            this._activityId = savedInstanceState.getInt(EXTRA_ACTIVITY_ID, -1);
            this._displayCutoutMode = savedInstanceState.getInt(EXTRA_DISPLAY_CUTOUT_MODE, 0);
            this.setKeepScreenOn(this._keepScreenOn);
            event = AdUnitEvent.ON_RESTORE;
        }
        this.setOrientation(this._orientation);
        this.setSystemUiVisibility(this._systemUiVisibility);
        this.setLayoutInDisplayCutoutMode(this._displayCutoutMode);
        if (this._views != null) {
            for (String viewName : this._views) {
                IAdUnitViewHandler handler = this.getViewHandler(viewName);
                if (handler == null) continue;
                handler.onCreate(this, savedInstanceState);
            }
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, event, this._activityId);
    }

    public AdUnitRelativeLayout getLayout() {
        return this._layout;
    }

    protected void onStart() {
        super.onStart();
        if (WebViewApp.getCurrentApp() == null) {
            if (!this.isFinishing()) {
                DeviceLog.error("Unity Ads web app is null, closing Unity Ads activity from onStart");
                this.finish();
            }
            return;
        }
        if (this._viewHandlers != null) {
            for (Map.Entry<String, IAdUnitViewHandler> entry : this._viewHandlers.entrySet()) {
                if (entry.getValue() == null) continue;
                entry.getValue().onStart(this);
            }
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.ON_START, this._activityId);
    }

    protected void onStop() {
        super.onStop();
        if (WebViewApp.getCurrentApp() == null) {
            if (!this.isFinishing()) {
                DeviceLog.error("Unity Ads web app is null, closing Unity Ads activity from onStop");
                this.finish();
            }
            return;
        }
        if (this._viewHandlers != null) {
            for (Map.Entry<String, IAdUnitViewHandler> entry : this._viewHandlers.entrySet()) {
                if (entry.getValue() == null) continue;
                entry.getValue().onStop(this);
            }
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.ON_STOP, this._activityId);
    }

    protected void onResume() {
        super.onResume();
        if (WebViewApp.getCurrentApp() == null) {
            if (!this.isFinishing()) {
                DeviceLog.error("Unity Ads web app is null, closing Unity Ads activity from onResume");
                this.finish();
            }
            return;
        }
        this.setViews(this._views);
        if (this._viewHandlers != null) {
            for (Map.Entry<String, IAdUnitViewHandler> entry : this._viewHandlers.entrySet()) {
                if (entry.getValue() == null) continue;
                entry.getValue().onResume(this);
            }
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.ON_RESUME, this._activityId);
    }

    protected void onPause() {
        super.onPause();
        if (WebViewApp.getCurrentApp() == null) {
            if (!this.isFinishing()) {
                DeviceLog.error("Unity Ads web app is null, closing Unity Ads activity from onPause");
                this.finish();
            }
            return;
        }
        if (WebViewApp.getCurrentApp().getWebView() == null) {
            DeviceLog.warning("Unity Ads web view is null, from onPause");
        } else if (this.isFinishing()) {
            ViewUtilities.removeViewFromParent((View)WebViewApp.getCurrentApp().getWebView());
        }
        if (this._viewHandlers != null) {
            for (Map.Entry<String, IAdUnitViewHandler> entry : this._viewHandlers.entrySet()) {
                if (entry.getValue() == null) continue;
                entry.getValue().onPause(this);
            }
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.ON_PAUSE, this.isFinishing(), this._activityId);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(EXTRA_ORIENTATION, this._orientation);
        outState.putInt(EXTRA_SYSTEM_UI_VISIBILITY, this._systemUiVisibility);
        outState.putIntegerArrayList(EXTRA_KEY_EVENT_LIST, this._keyEventList);
        outState.putBoolean(EXTRA_KEEP_SCREEN_ON, this._keepScreenOn);
        outState.putStringArray(EXTRA_VIEWS, this._views);
        outState.putInt(EXTRA_ACTIVITY_ID, this._activityId);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (WebViewApp.getCurrentApp() == null) {
            if (!this.isFinishing()) {
                DeviceLog.error("Unity Ads web app is null, closing Unity Ads activity from onDestroy");
                this.finish();
            }
            return;
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.ON_DESTROY, this.isFinishing(), this._activityId);
        if (this._viewHandlers != null) {
            for (Map.Entry<String, IAdUnitViewHandler> entry : this._viewHandlers.entrySet()) {
                if (entry.getValue() == null) continue;
                entry.getValue().onDestroy(this);
            }
        }
        if (AdUnit.getCurrentAdUnitActivityId() == this._activityId) {
            AdUnit.setAdUnitActivity(null);
        }
        Intent.removeActiveActivity(this);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this._keyEventList != null && this._keyEventList.contains(keyCode)) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.KEY_DOWN, keyCode, event.getEventTime(), event.getDownTime(), event.getRepeatCount(), this._activityId);
            return true;
        }
        return false;
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        if (hasFocus) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.ON_FOCUS_GAINED, this._activityId);
        } else {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.ON_FOCUS_LOST, this._activityId);
        }
        super.onWindowFocusChanged(hasFocus);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        try {
            JSONArray permissionsArray = new JSONArray();
            JSONArray grantResultsArray = new JSONArray();
            for (String permission : permissions) {
                permissionsArray.put((Object)permission);
            }
            for (int grantResult : grantResults) {
                grantResultsArray.put(grantResult);
            }
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.PERMISSIONS, PermissionsEvent.PERMISSIONS_RESULT, requestCode, permissionsArray, grantResultsArray);
        }
        catch (Exception e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.PERMISSIONS, PermissionsEvent.PERMISSIONS_ERROR, e.getMessage());
        }
    }

    public void setViewFrame(String view, int x, int y, int width, int height) {
        FrameLayout.LayoutParams params;
        IAdUnitViewHandler handler = this.getViewHandler(view);
        View targetView = null;
        if (view.equals("adunit")) {
            params = new FrameLayout.LayoutParams(width, height);
            params.setMargins(x, y, 0, 0);
            this._layout.setLayoutParams((ViewGroup.LayoutParams)params);
        } else if (handler != null) {
            targetView = handler.getView();
        }
        if (targetView != null) {
            params = new RelativeLayout.LayoutParams(width, height);
            params.setMargins(x, y, 0, 0);
            targetView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public Map<String, Integer> getViewFrame(String view) {
        IAdUnitViewHandler handler = this.getViewHandler(view);
        View targetView = null;
        if (view.equals("adunit")) {
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this._layout.getLayoutParams();
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("x", params.leftMargin);
            map.put("y", params.topMargin);
            map.put("width", this._layout.getWidth());
            map.put("height", this._layout.getHeight());
            return map;
        }
        if (handler != null) {
            targetView = handler.getView();
        }
        if (targetView != null) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)targetView.getLayoutParams();
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("x", params.leftMargin);
            map.put("y", params.topMargin);
            map.put("width", targetView.getWidth());
            map.put("height", targetView.getHeight());
            return map;
        }
        return null;
    }

    public void setViews(String[] views) {
        String[] actualViews = views == null ? new String[]{} : views;
        ArrayList<String> newViews = new ArrayList<String>(Arrays.asList(actualViews));
        if (this._views == null) {
            this._views = new String[0];
        }
        ArrayList<String> removedViews = new ArrayList<String>(Arrays.asList(this._views));
        removedViews.removeAll(newViews);
        for (String view : removedViews) {
            IAdUnitViewHandler handler = this.getViewHandler(view);
            handler.destroy();
        }
        this._views = actualViews;
        for (String view : actualViews) {
            if (view == null) continue;
            IAdUnitViewHandler handler = this.getViewHandler(view);
            handler.create(this);
            if (this.handleViewPlacement(handler.getView())) continue;
            return;
        }
    }

    private boolean handleViewPlacement(View view) {
        if (view == null) {
            this.finish();
            DeviceLog.error("Could not place view because it is null, finishing activity");
            return false;
        }
        if (view.getParent() != null && view.getParent().equals((Object)this._layout)) {
            this._layout.bringChildToFront(view);
        } else {
            ViewUtilities.removeViewFromParent(view);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            params.addRule(13);
            params.setMargins(0, 0, 0, 0);
            view.setPadding(0, 0, 0, 0);
            this._layout.addView(view, (ViewGroup.LayoutParams)params);
        }
        return true;
    }

    public String[] getViews() {
        return this._views;
    }

    public void setOrientation(int orientation) {
        this._orientation = orientation;
        this.setRequestedOrientation(orientation);
    }

    public boolean setKeepScreenOn(boolean keepScreenOn) {
        this._keepScreenOn = keepScreenOn;
        if (this.getWindow() == null) {
            return false;
        }
        if (keepScreenOn) {
            this.getWindow().addFlags(128);
        } else {
            this.getWindow().clearFlags(128);
        }
        return true;
    }

    public boolean setSystemUiVisibility(int flags) {
        this._systemUiVisibility = flags;
        if (Build.VERSION.SDK_INT >= 11) {
            try {
                this.getWindow().getDecorView().setSystemUiVisibility(flags);
                return true;
            }
            catch (Exception e) {
                DeviceLog.exception("Error while setting SystemUIVisibility", e);
                return false;
            }
        }
        return false;
    }

    public void setKeyEventList(ArrayList<Integer> keyevents) {
        this._keyEventList = keyevents;
    }

    public IAdUnitViewHandler getViewHandler(String name) {
        IAdUnitViewHandler viewHandler;
        if (this._viewHandlers != null && this._viewHandlers.containsKey(name)) {
            viewHandler = this._viewHandlers.get(name);
        } else {
            viewHandler = this._adUnitViewHandlerFactory.createViewHandler(name);
            if (viewHandler != null) {
                if (this._viewHandlers == null) {
                    this._viewHandlers = new HashMap<String, IAdUnitViewHandler>();
                }
                this._viewHandlers.put(name, viewHandler);
            }
        }
        return viewHandler;
    }

    public void setLayoutInDisplayCutoutMode(int flags) {
        this._displayCutoutMode = flags;
        if (Build.VERSION.SDK_INT >= 28 && this.getWindow() != null) {
            WindowManager.LayoutParams lp = this.getWindow().getAttributes();
            try {
                Field layoutInDisplayCutoutMode = lp.getClass().getField("layoutInDisplayCutoutMode");
                layoutInDisplayCutoutMode.setInt(lp, flags);
            }
            catch (IllegalAccessException e) {
                DeviceLog.debug("Error setting layoutInDisplayCutoutMode", e);
            }
            catch (NoSuchFieldException e) {
                DeviceLog.debug("Error getting layoutInDisplayCutoutMode", e);
            }
        }
    }

    protected void createLayout() {
        if (this._layout != null) {
            return;
        }
        this._layout = new AdUnitRelativeLayout((Context)this);
        this._layout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        ViewUtilities.setBackground((View)this._layout, (Drawable)new ColorDrawable(-16777216));
    }
}

