/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.token;

import android.os.Handler;
import android.os.Looper;
import com.unity3d.services.ads.gmascar.GMA;
import com.unity3d.services.ads.gmascar.managers.IBiddingManager;
import com.unity3d.services.ads.token.INativeTokenGenerator;
import com.unity3d.services.ads.token.INativeTokenGeneratorListener;
import com.unity3d.services.ads.token.NativeTokenGenerator;
import com.unity3d.services.ads.token.NativeTokenGeneratorWithPrivacyAwait;
import com.unity3d.services.ads.token.TokenStorage;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.configuration.PrivacyConfigStorage;
import com.unity3d.services.core.device.TokenType;
import com.unity3d.services.core.device.reader.DeviceInfoReaderBuilderWithExtras;
import com.unity3d.services.core.device.reader.GameSessionIdReader;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.InitializationStatusReader;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.metrics.ISDKMetrics;
import com.unity3d.services.core.request.metrics.SDKMetrics;
import com.unity3d.services.core.request.metrics.TSIMetric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AsyncTokenStorage {
    private final List<TokenListenerState> _tokenListeners = new LinkedList<TokenListenerState>();
    private final Handler _handler;
    private boolean _tokenAvailable = false;
    private boolean _configurationWasSet = false;
    private Configuration _configuration = new Configuration();
    private INativeTokenGenerator _nativeTokenGenerator;
    private final InitializationStatusReader _initStatusReader = new InitializationStatusReader();
    private final ISDKMetrics _sdkMetrics;
    private DeviceInfoReaderBuilderWithExtras _deviceInfoReaderBuilderWithExtras;
    private TokenStorage _tokenStorage;
    private static AsyncTokenStorage _instance;

    public static AsyncTokenStorage getInstance() {
        if (_instance == null) {
            _instance = new AsyncTokenStorage(null, new Handler(Looper.getMainLooper()), SDKMetrics.getInstance(), TokenStorage.getInstance());
        }
        return _instance;
    }

    public AsyncTokenStorage(INativeTokenGenerator nativeTokenGenerator, Handler handler, ISDKMetrics sdkMetrics, TokenStorage tokenStorage) {
        this._handler = handler;
        this._nativeTokenGenerator = nativeTokenGenerator;
        this._sdkMetrics = sdkMetrics;
        this._tokenStorage = tokenStorage;
    }

    public synchronized void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
        this._configurationWasSet = this.isValidConfig(this._configuration);
        if (!this._configurationWasSet) {
            return;
        }
        if (this._nativeTokenGenerator == null) {
            this._deviceInfoReaderBuilderWithExtras = new DeviceInfoReaderBuilderWithExtras(new ConfigurationReader(), PrivacyConfigStorage.getInstance(), GameSessionIdReader.getInstance());
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            this._nativeTokenGenerator = new NativeTokenGenerator(executorService, this._deviceInfoReaderBuilderWithExtras);
            if (configuration.getExperiments().shouldNativeTokenAwaitPrivacy()) {
                this._nativeTokenGenerator = new NativeTokenGeneratorWithPrivacyAwait(executorService, this._nativeTokenGenerator, configuration.getPrivacyRequestWaitTimeout());
            }
        }
        ArrayList<TokenListenerState> tempList = new ArrayList<TokenListenerState>(this._tokenListeners);
        for (TokenListenerState state : tempList) {
            this.handleTokenInvocation(state);
        }
    }

    public synchronized void onTokenAvailable() {
        this._tokenAvailable = true;
        if (!this._configurationWasSet) {
            return;
        }
        this.notifyListenersTokenReady();
    }

    public synchronized void getToken(IBiddingManager biddingManager) {
        if (SdkProperties.getCurrentInitializationState() == SdkProperties.InitializationState.INITIALIZED_FAILED) {
            biddingManager.onUnityAdsTokenReady(null);
            this.sendTokenMetrics(null, TokenType.TOKEN_REMOTE);
            return;
        }
        if (SdkProperties.getCurrentInitializationState() == SdkProperties.InitializationState.NOT_INITIALIZED) {
            biddingManager.onUnityAdsTokenReady(null);
            this.sendTokenMetrics(null, TokenType.TOKEN_REMOTE);
            return;
        }
        TokenListenerState state = this.addTimeoutHandler(biddingManager);
        if (!this._configurationWasSet) {
            return;
        }
        this.handleTokenInvocation(state);
    }

    private synchronized TokenListenerState addTimeoutHandler(IBiddingManager biddingManager) {
        final TokenListenerState state = new TokenListenerState();
        state.biddingManager = biddingManager;
        state.tokenType = TokenType.TOKEN_REMOTE;
        state.runnable = new Runnable(){

            @Override
            public void run() {
                AsyncTokenStorage.this.notifyTokenReady(state, null);
            }
        };
        this._tokenListeners.add(state);
        this._handler.postDelayed(state.runnable, (long)this._configuration.getTokenTimeout());
        return state;
    }

    private synchronized void notifyListenersTokenReady() {
        String token;
        while (!this._tokenListeners.isEmpty() && (token = this._tokenStorage.getToken()) != null) {
            this.notifyTokenReady(this._tokenListeners.get(0), token);
        }
    }

    private void handleTokenInvocation(final TokenListenerState state) {
        if (state.invoked) {
            return;
        }
        state.invoked = true;
        if (!this._tokenAvailable) {
            state.tokenType = TokenType.TOKEN_NATIVE;
            if (GMA.getInstance().hasSCARBiddingSupport() && this._deviceInfoReaderBuilderWithExtras != null) {
                HashMap<String, String> extras = new HashMap<String, String>();
                extras.put("tid", state.biddingManager.getTokenIdentifier());
                this._deviceInfoReaderBuilderWithExtras.setExtras(extras);
            }
            this._nativeTokenGenerator.generateToken(new INativeTokenGeneratorListener(){

                @Override
                public void onReady(final String token) {
                    AsyncTokenStorage.this._handler.post(new Runnable(){

                        @Override
                        public void run() {
                            AsyncTokenStorage.this.notifyTokenReady(state, token);
                        }
                    });
                }
            });
        } else {
            state.tokenType = TokenType.TOKEN_REMOTE;
            String token = this._tokenStorage.getToken();
            if (token == null || token.isEmpty()) {
                return;
            }
            this.notifyTokenReady(state, token);
        }
    }

    private synchronized void notifyTokenReady(TokenListenerState state, String token) {
        if (this._tokenListeners.remove(state)) {
            String formattedToken = state.tokenType == TokenType.TOKEN_REMOTE ? state.biddingManager.getFormattedToken(token) : token;
            state.biddingManager.onUnityAdsTokenReady(formattedToken);
            try {
                this._handler.removeCallbacks(state.runnable);
            }
            catch (Exception ex) {
                DeviceLog.exception("Failed to remove callback from a handler", ex);
            }
        }
        this.sendTokenMetrics(token, state.tokenType);
    }

    private void sendTokenMetrics(String token, TokenType type) {
        switch (type) {
            case TOKEN_NATIVE: {
                this.sendNativeTokenMetrics(token);
                break;
            }
            case TOKEN_REMOTE: {
                this.sendRemoteTokenMetrics(token);
                break;
            }
            default: {
                DeviceLog.error("Unknown token type passed to sendTokenMetrics");
            }
        }
    }

    private void sendNativeTokenMetrics(String token) {
        if (this._sdkMetrics == null) {
            return;
        }
        if (token == null) {
            this._sdkMetrics.sendMetric(TSIMetric.newNativeGeneratedTokenNull(this.getMetricTags()));
        } else {
            this._sdkMetrics.sendMetric(TSIMetric.newNativeGeneratedTokenAvailable(this.getMetricTags()));
        }
    }

    private void sendRemoteTokenMetrics(String token) {
        if (this._sdkMetrics == null) {
            return;
        }
        if (token == null || token.isEmpty()) {
            this._sdkMetrics.sendMetric(TSIMetric.newAsyncTokenNull(this.getMetricTags()));
        } else {
            this._sdkMetrics.sendMetric(TSIMetric.newAsyncTokenAvailable(this.getMetricTags()));
        }
    }

    private Map<String, String> getMetricTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("state", this._initStatusReader.getInitializationStateString(SdkProperties.getCurrentInitializationState()));
        return tags;
    }

    private boolean isValidConfig(Configuration configuration) {
        return configuration != null;
    }

    class TokenListenerState {
        public IBiddingManager biddingManager;
        public Runnable runnable;
        public boolean invoked;
        public TokenType tokenType;

        TokenListenerState() {
        }
    }
}

