/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.gmascar.managers;

import com.unity3d.ads.IUnityAdsTokenListener;
import com.unity3d.services.ads.gmascar.GMA;
import com.unity3d.services.ads.gmascar.managers.BiddingBaseManager;
import com.unity3d.services.ads.gmascar.managers.BiddingDisabledManager;
import com.unity3d.services.ads.gmascar.managers.BiddingEagerManager;
import com.unity3d.services.ads.gmascar.managers.BiddingLazyManager;
import com.unity3d.services.ads.gmascar.managers.BiddingOnDemandManager;
import com.unity3d.services.ads.gmascar.managers.SCARBiddingManagerType;
import com.unity3d.services.core.configuration.IExperiments;

public class BiddingManagerFactory {
    private static BiddingManagerFactory instance;

    private BiddingManagerFactory() {
    }

    public static BiddingManagerFactory getInstance() {
        if (instance == null) {
            instance = new BiddingManagerFactory();
        }
        return instance;
    }

    public BiddingBaseManager createManager(IUnityAdsTokenListener unityAdsTokenListener, IExperiments experiments) {
        if (GMA.getInstance().hasSCARBiddingSupport()) {
            if (unityAdsTokenListener == null || experiments == null) {
                return new BiddingEagerManager(null);
            }
            return this.getExperiment(unityAdsTokenListener, experiments);
        }
        return new BiddingDisabledManager(unityAdsTokenListener);
    }

    private BiddingBaseManager getExperiment(IUnityAdsTokenListener unityAdsTokenListener, IExperiments experiments) {
        String biddingManager = experiments.getScarBiddingManager();
        switch (SCARBiddingManagerType.fromName(biddingManager)) {
            case EAGER: {
                return new BiddingEagerManager(unityAdsTokenListener);
            }
            case LAZY: {
                return new BiddingLazyManager(unityAdsTokenListener);
            }
            case HYBRID: {
                return new BiddingOnDemandManager(unityAdsTokenListener);
            }
        }
        return new BiddingDisabledManager(unityAdsTokenListener);
    }
}

