/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.scar.adapter.common.signals;

import android.content.Context;
import com.unity3d.scar.adapter.common.DispatchGroup;
import com.unity3d.scar.adapter.common.signals.ISignalCollectionListener;
import com.unity3d.scar.adapter.common.signals.ISignalsCollector;
import com.unity3d.scar.adapter.common.signals.SignalsResult;
import java.util.Map;
import org.json.JSONObject;

public abstract class SignalsCollectorBase
implements ISignalsCollector {
    @Override
    public void getSCARSignals(Context context, String[] interstitialList, String[] rewardedList, ISignalCollectionListener signalCompletionListener) {
        DispatchGroup dispatchGroup = new DispatchGroup();
        SignalsResult signalsResult = new SignalsResult();
        for (String interstitialId : interstitialList) {
            dispatchGroup.enter();
            this.getSCARSignal(context, interstitialId, true, dispatchGroup, signalsResult);
        }
        for (String rewardedId : rewardedList) {
            dispatchGroup.enter();
            this.getSCARSignal(context, rewardedId, false, dispatchGroup, signalsResult);
        }
        dispatchGroup.notify(new GMAScarDispatchCompleted(signalCompletionListener, signalsResult));
    }

    private class GMAScarDispatchCompleted
    implements Runnable {
        private ISignalCollectionListener _signalListener;
        private SignalsResult _signalsResult;

        public GMAScarDispatchCompleted(ISignalCollectionListener signalListener, SignalsResult signalsResult) {
            this._signalListener = signalListener;
            this._signalsResult = signalsResult;
        }

        @Override
        public void run() {
            Map<String, String> signalsMap = this._signalsResult.getSignalsMap();
            if (signalsMap.size() > 0) {
                JSONObject placementJSON = new JSONObject(signalsMap);
                this._signalListener.onSignalsCollected(placementJSON.toString());
            } else if (this._signalsResult.getErrorMessage() == null) {
                this._signalListener.onSignalsCollected("");
            } else {
                this._signalListener.onSignalsCollectionFailed(this._signalsResult.getErrorMessage());
            }
        }
    }
}

