/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.request.metrics;

import com.unity3d.services.core.request.metrics.Metric;
import com.unity3d.services.core.request.metrics.MetricCommonTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetricsContainer {
    private static final String METRICS_CONTAINER = "m";
    private static final String METRICS_CONTAINER_TAGS = "t";
    private static final String METRIC_CONTAINER_SAMPLE_RATE = "msr";
    private static final String METRIC_CONTAINER_SESSION_TOKEN = "sTkn";
    private final MetricCommonTags _commonTags;
    private final List<Metric> _metrics;
    private final String _metricSampleRate;
    private final String _sTkn;

    public MetricsContainer(String metricSampleRate, MetricCommonTags commonTags, List<Metric> metrics, String sTkn) {
        this._metricSampleRate = metricSampleRate;
        this._commonTags = commonTags;
        this._metrics = metrics;
        this._sTkn = sTkn;
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> metricsMaps = new ArrayList<Map<String, Object>>();
        for (Metric metric : this._metrics) {
            metricsMaps.add(metric.asMap());
        }
        result.put(METRIC_CONTAINER_SAMPLE_RATE, this._metricSampleRate);
        result.put(METRICS_CONTAINER, metricsMaps);
        result.put(METRICS_CONTAINER_TAGS, this._commonTags.asMap());
        result.put(METRIC_CONTAINER_SESSION_TOKEN, this._sTkn);
        return result;
    }
}

