/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.ads.UnityAds;
import com.unity3d.services.core.api.Broadcast;
import com.unity3d.services.core.api.Cache;
import com.unity3d.services.core.api.ClassDetection;
import com.unity3d.services.core.api.Connectivity;
import com.unity3d.services.core.api.DeviceInfo;
import com.unity3d.services.core.api.Intent;
import com.unity3d.services.core.api.Lifecycle;
import com.unity3d.services.core.api.Permissions;
import com.unity3d.services.core.api.Preferences;
import com.unity3d.services.core.api.Request;
import com.unity3d.services.core.api.Resolve;
import com.unity3d.services.core.api.Sdk;
import com.unity3d.services.core.api.SensorInfo;
import com.unity3d.services.core.api.Storage;
import com.unity3d.services.core.broadcast.BroadcastMonitor;
import com.unity3d.services.core.cache.CacheThread;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.ErrorState;
import com.unity3d.services.core.configuration.IModuleConfiguration;
import com.unity3d.services.core.configuration.InitializationNotificationCenter;
import com.unity3d.services.core.connectivity.ConnectivityMonitor;
import com.unity3d.services.core.device.AdvertisingId;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.device.OpenAdvertisingId;
import com.unity3d.services.core.device.StorageManager;
import com.unity3d.services.core.device.VolumeChange;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.WebRequestThread;
import com.unity3d.services.core.request.metrics.Metric;
import com.unity3d.services.core.request.metrics.SDKMetrics;
import java.util.ArrayList;

public class CoreModuleConfiguration
implements IModuleConfiguration {
    @Override
    public Class[] getWebAppApiClassList() {
        Class[] list = new Class[]{Broadcast.class, Cache.class, Connectivity.class, DeviceInfo.class, ClassDetection.class, Storage.class, Sdk.class, Request.class, Resolve.class, Intent.class, Lifecycle.class, Preferences.class, SensorInfo.class, Permissions.class};
        return list;
    }

    @Override
    public boolean resetState(Configuration configuration) {
        BroadcastMonitor.removeAllBroadcastListeners();
        CacheThread.cancel();
        WebRequestThread.cancel();
        ConnectivityMonitor.stopAll();
        StorageManager.init(ClientProperties.getApplicationContext());
        AdvertisingId.init(ClientProperties.getApplicationContext());
        OpenAdvertisingId.init(ClientProperties.getApplicationContext());
        VolumeChange.clearAllListeners();
        return true;
    }

    @Override
    public boolean initModuleState(Configuration configuration) {
        return true;
    }

    @Override
    public boolean initErrorState(Configuration configuration, ErrorState state, String errorMessage) {
        UnityAds.UnityAdsInitializationError error;
        String message;
        SDKMetrics.setConfiguration(configuration);
        switch (state) {
            case CreateWebApp: {
                message = errorMessage;
                error = UnityAds.UnityAdsInitializationError.INTERNAL_ERROR;
                break;
            }
            case InitModules: {
                message = errorMessage;
                error = UnityAds.UnityAdsInitializationError.AD_BLOCKER_DETECTED;
                break;
            }
            default: {
                message = "Unity Ads failed to initialize due to internal error";
                error = UnityAds.UnityAdsInitializationError.INTERNAL_ERROR;
            }
        }
        InitializationNotificationCenter.getInstance().triggerOnSdkInitializationFailed(message, state, 0);
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SdkProperties.notifyInitializationFailed(error, message);
            }
        });
        return true;
    }

    @Override
    public boolean initCompleteState(Configuration configuration) {
        SDKMetrics.setConfiguration(configuration);
        InitializationNotificationCenter.getInstance().triggerOnSdkInitialized();
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SdkProperties.notifyInitializationComplete();
            }
        });
        this.collectMetrics();
        return true;
    }

    private void collectMetrics() {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        int hasX264 = Device.hasX264Decoder() ? 1 : 0;
        int hasX265 = Device.hasX265Decoder() ? 1 : 0;
        metrics.add(new Metric("native_device_decoder_x264", hasX264, null));
        metrics.add(new Metric("native_device_decoder_x265", hasX265, null));
        SDKMetrics.getInstance().sendMetrics(metrics);
    }
}

