/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.gmascar.finder;

import com.unity3d.scar.adapter.common.GMAEvent;
import com.unity3d.services.ads.gmascar.bridges.AdapterStatusBridge;
import com.unity3d.services.ads.gmascar.bridges.InitializationStatusBridge;
import com.unity3d.services.ads.gmascar.bridges.InitializeListenerBridge;
import com.unity3d.services.ads.gmascar.bridges.mobileads.MobileAdsBridgeBase;
import com.unity3d.services.ads.gmascar.utils.GMAEventSender;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.util.Map;

public class GMAInitializer {
    private MobileAdsBridgeBase _mobileAdsBridge;
    private InitializeListenerBridge _initializationListenerBridge;
    private InitializationStatusBridge _initializationStatusBridge;
    private AdapterStatusBridge _adapterStatusBridge;
    private GMAEventSender _gmaEventSender;

    public GMAInitializer(MobileAdsBridgeBase mobileAdsBridge, InitializeListenerBridge initializeListenerBridge, InitializationStatusBridge initializationStatusBridge, AdapterStatusBridge adapterStatusBridge) {
        this._mobileAdsBridge = mobileAdsBridge;
        this._initializationListenerBridge = initializeListenerBridge;
        this._initializationStatusBridge = initializationStatusBridge;
        this._adapterStatusBridge = adapterStatusBridge;
        this._gmaEventSender = new GMAEventSender();
    }

    public void initializeGMA() {
        if (this.shouldInitialize()) {
            this._mobileAdsBridge.initialize(ClientProperties.getApplicationContext(), this._initializationListenerBridge.createInitializeListenerProxy());
        }
    }

    public boolean initSuccessful(Object initStatus) {
        Map<String, Object> statusMap = this._initializationStatusBridge.getAdapterStatusMap(initStatus);
        Object adapterState = statusMap.get(this._mobileAdsBridge.getClassName());
        if (adapterState != null) {
            if (this._adapterStatusBridge.isGMAInitialized(adapterState)) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.GMA, (Enum)GMAEvent.INIT_SUCCESS, new Object[0]);
                return true;
            }
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.GMA, (Enum)GMAEvent.INIT_ERROR, new Object[0]);
            return false;
        }
        return false;
    }

    public boolean isInitialized() {
        boolean isInitialized = false;
        try {
            isInitialized = this.initSuccessful(this._mobileAdsBridge.getInitializationStatus());
        }
        catch (Exception e) {
            DeviceLog.debug("ERROR: Could not get initialization status of GMA SDK - %s", e.getLocalizedMessage());
        }
        return isInitialized;
    }

    public boolean shouldInitialize() {
        if (this.isInitialized()) {
            this._gmaEventSender.send(GMAEvent.ALREADY_INITIALIZED, new Object[0]);
            return false;
        }
        return this._mobileAdsBridge.shouldInitialize();
    }

    public InitializeListenerBridge getInitializeListenerBridge() {
        return this._initializationListenerBridge;
    }
}

