/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.UnityAdsSDK;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.configuration.EnvironmentCheck;
import com.unity3d.services.core.configuration.InitializeEventsMetricSender;
import com.unity3d.services.core.configuration.InitializeThread;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.SdkProperties;

public class UnityServices {
    /*
     * Enabled aggressive block sorting
     */
    public static void initialize(Context context, String gameId, boolean testMode, IUnityAdsInitializationListener initializationListener) {
        DeviceLog.entered();
        if (SdkProperties.getCurrentInitializationState() != SdkProperties.InitializationState.NOT_INITIALIZED) {
            boolean previousTestMode;
            String differingParameters = "";
            String previousGameId = ClientProperties.getGameId();
            if (previousGameId != null && !previousGameId.equals(gameId)) {
                differingParameters = differingParameters + UnityServices.createExpectedParametersString("Game ID", ClientProperties.getGameId(), gameId);
            }
            if ((previousTestMode = SdkProperties.isTestMode()) != testMode) {
                differingParameters = differingParameters + UnityServices.createExpectedParametersString("Test Mode", previousTestMode, testMode);
            }
            if (!TextUtils.isEmpty((CharSequence)differingParameters)) {
                String message = "Unity Ads SDK failed to initialize due to already being initialized with different parameters" + differingParameters;
                DeviceLog.warning(message);
                if (initializationListener == null) return;
                initializationListener.onInitializationFailed(UnityAds.UnityAdsInitializationError.INVALID_ARGUMENT, message);
                return;
            }
        }
        SdkProperties.addInitializationListener(initializationListener);
        if (SdkProperties.getCurrentInitializationState() == SdkProperties.InitializationState.INITIALIZED_SUCCESSFULLY) {
            SdkProperties.notifyInitializationComplete();
            return;
        }
        if (SdkProperties.getCurrentInitializationState() == SdkProperties.InitializationState.INITIALIZED_FAILED) {
            SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INTERNAL_ERROR, "Unity Ads SDK failed to initialize due to previous failed reason");
            return;
        }
        if (SdkProperties.getCurrentInitializationState() == SdkProperties.InitializationState.INITIALIZING) {
            return;
        }
        SdkProperties.setInitializeState(SdkProperties.InitializationState.INITIALIZING);
        ClientProperties.setGameId(gameId);
        SdkProperties.setTestMode(testMode);
        if (!UnityServices.isSupported()) {
            DeviceLog.error("Error while initializing Unity Services: device is not supported");
            SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INTERNAL_ERROR, "Unity Ads SDK failed to initialize due to device is not supported");
            return;
        }
        SdkProperties.setInitializationTime(Device.getElapsedRealtime());
        SdkProperties.setInitializationTimeSinceEpoch(System.currentTimeMillis());
        if (gameId == null || gameId.length() == 0) {
            DeviceLog.error("Error while initializing Unity Services: empty game ID, halting Unity Ads init");
            SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INVALID_ARGUMENT, "Unity Ads SDK failed to initialize due to empty game ID");
            return;
        }
        if (context == null) {
            DeviceLog.error("Error while initializing Unity Services: null context, halting Unity Ads init");
            SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INVALID_ARGUMENT, "Unity Ads SDK failed to initialize due to null context");
            return;
        }
        if (context instanceof Application) {
            ClientProperties.setApplication((Application)context);
        } else {
            if (!(context instanceof Activity)) {
                DeviceLog.error("Error while initializing Unity Services: invalid context, halting Unity Ads init");
                SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INVALID_ARGUMENT, "Unity Ads SDK failed to initialize due to invalid context");
                return;
            }
            if (((Activity)context).getApplication() == null) {
                DeviceLog.error("Error while initializing Unity Services: cannot retrieve application from context, halting Unity Ads init");
                SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INVALID_ARGUMENT, "Unity Ads SDK failed to initialize due to inability to retrieve application from context");
                return;
            }
            ClientProperties.setApplication(((Activity)context).getApplication());
        }
        if (testMode) {
            DeviceLog.info("Initializing Unity Services " + SdkProperties.getVersionName() + " (" + SdkProperties.getVersionCode() + ") with game id " + gameId + " in test mode");
        } else {
            DeviceLog.info("Initializing Unity Services " + SdkProperties.getVersionName() + " (" + SdkProperties.getVersionCode() + ") with game id " + gameId + " in production mode");
        }
        SdkProperties.setDebugMode(SdkProperties.getDebugMode());
        if (context.getApplicationContext() == null) {
            DeviceLog.error("Error while initializing Unity Services: cannot retrieve application context, halting Unity Ads init");
            SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INVALID_ARGUMENT, "Unity Ads SDK failed to initialize due to inability to retrieve application context");
            return;
        }
        ClientProperties.setApplicationContext(context.getApplicationContext());
        if (!EnvironmentCheck.isEnvironmentOk()) {
            DeviceLog.error("Error during Unity Services environment check, halting Unity Services init");
            SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INTERNAL_ERROR, "Unity Ads SDK failed to initialize due to environment check failed");
            return;
        }
        DeviceLog.info("Unity Services environment check OK");
        ConfigurationReader configurationReader = new ConfigurationReader();
        Configuration configuration = configurationReader.getCurrentConfiguration();
        boolean isNewInitFlow = configuration.getExperiments().isNewInitFlowEnabled();
        InitializeEventsMetricSender.getInstance().setNewInitFlow(isNewInitFlow);
        if (isNewInitFlow) {
            UnityAdsSDK.INSTANCE.initialize();
            return;
        }
        InitializeThread.initialize(configuration);
    }

    public static boolean isSupported() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public static boolean isInitialized() {
        return SdkProperties.isInitialized();
    }

    public static String getVersion() {
        return SdkProperties.getVersionName();
    }

    public static void setDebugMode(boolean debugMode) {
        SdkProperties.setDebugMode(debugMode);
    }

    public static boolean getDebugMode() {
        return SdkProperties.getDebugMode();
    }

    private static String createExpectedParametersString(String fieldName, Object current, Object received) {
        String currentSafeString = current == null ? "null" : current.toString();
        String receivedSafeString = received == null ? "null" : received.toString();
        return "\n - " + fieldName + " Current: " + currentSafeString + " | Received: " + receivedSafeString;
    }

    public static enum UnityServicesError {
        INVALID_ARGUMENT,
        INIT_SANITY_CHECK_FAIL;

    }
}

