/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.request.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Metric {
    private static final String METRIC_NAME = "n";
    private static final String METRIC_VALUE = "v";
    private static final String METRIC_TAGS = "t";
    private final String name;
    private final Object value;
    private final Map<String, String> tags;

    public Metric(String name, Object value, Map<String, String> tags) {
        this.name = name;
        this.value = value;
        this.tags = tags;
    }

    Map<String, Object> asMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.name != null) {
            result.put(METRIC_NAME, this.name);
        }
        if (this.value != null) {
            result.put(METRIC_VALUE, this.value);
        }
        if (this.tags != null) {
            result.put(METRIC_TAGS, this.tags);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "Metric{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", tags=" + this.tags + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metric)) {
            return false;
        }
        Metric metric = (Metric)o;
        return Objects.equals(this.name, metric.name) && Objects.equals(this.value, metric.value) && Objects.equals(this.tags, metric.tags);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.tags);
    }
}

