/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader;

import com.unity3d.services.core.device.reader.IDeviceInfoReader;
import com.unity3d.services.core.request.metrics.SDKMetrics;
import com.unity3d.services.core.request.metrics.TSIMetric;
import java.util.Map;

public class DeviceInfoReaderWithMetrics
implements IDeviceInfoReader {
    private final IDeviceInfoReader _deviceInfoReader;

    public DeviceInfoReaderWithMetrics(IDeviceInfoReader deviceInfoReader) {
        this._deviceInfoReader = deviceInfoReader;
    }

    @Override
    public Map<String, Object> getDeviceInfoData() {
        if (this._deviceInfoReader == null) {
            return null;
        }
        Map<String, Object> deviceInfo = this._deviceInfoReader.getDeviceInfoData();
        this.sendMetrics(deviceInfo);
        return deviceInfo;
    }

    private void sendMetrics(Map<String, Object> deviceInfoData) {
        Object gameSessionId;
        if (deviceInfoData != null && (gameSessionId = deviceInfoData.get("unifiedconfig.data.gameSessionId")) instanceof Long && (Long)gameSessionId == 0L) {
            SDKMetrics.getInstance().sendMetric(TSIMetric.newMissingGameSessionId());
        }
    }
}

